package com.tydic.train.service.course;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.train.model.mc.good.TrainMcGoodDo;
import com.tydic.train.model.mc.good.TrainMcGoodModel;
import com.tydic.train.model.mc.good.qrybo.TrainMcGoodQryBo;
import com.tydic.train.model.mc.order.TrainMcOrderDo;
import com.tydic.train.model.mc.order.TrainMcOrderModel;
import com.tydic.train.model.mc.order.qrybo.TrainMcOrderQryBo;
import com.tydic.train.model.mc.user.TrainMcUserDo;
import com.tydic.train.model.mc.user.TrainMcUserModel;
import com.tydic.train.model.mc.user.qrybo.TrainMcUserQryBo;
import com.tydic.train.service.course.bo.*;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：TrainModelQryOrderInfoServiceImpl
 * 说明：
 * 时间：2023/08/28 20:36
 *
 * @author 马冲
 **/
@HTServiceImpl
public class TrainMcQryOrderInfoServiceImpl implements TrainMcQryOrderInfoService {

    @Autowired
    private TrainMcGoodModel trainMcGoodModel;
    @Autowired
    private TrainMcUserModel trainMcUserModel;
    @Autowired
    private TrainMcOrderModel trainMcOrderModel;

    @Override
    public TrainMcQryOrderInfoRspBo qryOrderInfo(TrainMcQryOrderInfoReqBo reqBo) {

        TrainMcOrderQryBo orderQryBo = new TrainMcOrderQryBo();
        orderQryBo.setOrderId(reqBo.getOrderId());
        TrainMcOrderDo orderDo = trainMcOrderModel.queryOrder(orderQryBo);
        TrainMcOrderBo orderBo = JSONObject.parseObject(JSON.toJSONString(orderDo), TrainMcOrderBo.class);

        TrainMcUserQryBo userQryBo = new TrainMcUserQryBo();
        userQryBo.setUserId(orderBo.getCreateUserId());
        TrainMcUserDo userDo = trainMcUserModel.qryUser(userQryBo);
        TrainMcUserBo userBo = JSON.parseObject(JSON.toJSONString(userDo), TrainMcUserBo.class);

        TrainMcGoodQryBo goodQryBo = new TrainMcGoodQryBo();
        goodQryBo.setGoodsId(orderBo.getOrderItemBoList().get(0).getGoodsId());
        TrainMcGoodDo goodDo = trainMcGoodModel.qryGoods(goodQryBo);
        TrainMcGoodBo goodBo = JSON.parseObject(JSON.toJSONString(goodDo), TrainMcGoodBo.class);

        TrainMcQryOrderInfoRspBo rspBo = new TrainMcQryOrderInfoRspBo();
        rspBo.setOrderBo(orderBo);
        rspBo.setUserBo(userBo);
        rspBo.setGoodBo(goodBo);
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }
}
