package com.tydic.train.service.course;

import com.tydic.train.model.mc.order.TrainMcOrderModel;
import com.tydic.train.model.mc.order.sub.TrainMcOrder;
import com.tydic.train.service.course.bo.TrainMcUpdateOrderReqBO;
import com.tydic.train.service.course.bo.TrainMcUpdateOrderRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：TrainMcUpdateOrderServiceImpl
 * 说明：修改订单API
 * 时间：2023/08/31 11:36
 *
 * @author 马冲
 **/
@HTServiceImpl
public class TrainMcUpdateOrderServiceImpl implements TrainMcUpdateOrderService{

    @Autowired
    private TrainMcOrderModel trainMcOrderModel;

    @Override
    public TrainMcUpdateOrderRspBO updateOrder(TrainMcUpdateOrderReqBO reqBO) {

        TrainMcOrder order = JsonUtil.js(reqBO, TrainMcOrder.class);
        trainMcOrderModel.updateOrder(order);
        TrainMcUpdateOrderRspBO rspBO = new TrainMcUpdateOrderRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
