package com.tydic.train.service.gdx.order;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.constants.TrainOrderStatusEnum;
import com.tydic.train.model.gdx.goods.TrainGdxGoodsDo;
import com.tydic.train.model.gdx.goods.TrainGdxGoodsModel;
import com.tydic.train.model.gdx.order.TrainGdxOrderModel;
import com.tydic.train.model.gdx.order.qrybo.TrainGdxOrderQryBo;
import com.tydic.train.model.gdx.user.TrainGdxUserDo;
import com.tydic.train.model.gdx.user.TrainGdxUserModel;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.gdx.order.bo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/28 19:14
 */
@HTServiceImpl
@RequiredArgsConstructor
public class TrainGdxOrderServiceImpl implements TrainGdxOrderService {

    private final TrainGdxOrderModel trainGdxOrderModel;

    private final TrainGdxUserModel trainGdxUserModel;

    private final TrainGdxGoodsModel trainGdxGoodsModel;


    @Override
    public TrainGdxCreateBatchOrderRspBo createBatchOrder(TrainGdxCreateBatchOrderReqBo batchOrderReqBo) {
        if (CollectionUtil.isEmpty(batchOrderReqBo.getOrderItemList()) || batchOrderReqBo.getUserId() == null) {
            throw new ZTBusinessException("参数异常");
        }

        TrainGdxUserDo byId = trainGdxUserModel.getById(batchOrderReqBo.getUserId());
        if (byId == null) {
            throw new BaseBusinessException("1002", "用户不存在");
        }

        // 组装订单数据
        TrainGdxOrderBo trainGdxOrderBo = new TrainGdxOrderBo();
        trainGdxOrderBo.setOrderNo(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        trainGdxOrderBo.setOrderName(DateUtil.format(new Date(), "yyyy-MM-dd") + "的订单");

        trainGdxOrderBo.setCreateUserId(batchOrderReqBo.getUserId());
        trainGdxOrderBo.setCreateUserName(byId.getUserName());
        trainGdxOrderBo.setCreateTime(new Date());
        trainGdxOrderBo.setOrderStatus(TrainOrderStatusEnum.O_000.getOrderStatus());

        BigDecimal totalAmt = BigDecimal.ZERO;
        List<TrainGdxOrderItemBo> itemBoList = new ArrayList<>();
        for (TrainGdxCreateBatchOrderReqBo.TrainGdxOrderItem orderItem : batchOrderReqBo.getOrderItemList()) {
            TrainGdxGoodsDo trainGdxGoodsDo = trainGdxGoodsModel.getById(orderItem.getGoodsId());
            if (trainGdxGoodsDo == null) {
                throw new BaseBusinessException("1003", "商品不存在");
            }
            TrainGdxOrderItemBo trainGdxOrderItemBo = new TrainGdxOrderItemBo();
            trainGdxOrderItemBo.setGoodsId(orderItem.getGoodsId());
            trainGdxOrderItemBo.setGoodsPrice(trainGdxGoodsDo.getGoodsPrice());
            trainGdxOrderItemBo.setCount(orderItem.getNum());
            trainGdxOrderItemBo.setTotalMoney(trainGdxGoodsDo.getGoodsPrice().multiply(new BigDecimal(orderItem.getNum())));
            totalAmt = totalAmt.add(trainGdxOrderItemBo.getTotalMoney());
            itemBoList.add(trainGdxOrderItemBo);
        }
        trainGdxOrderBo.setOrderMoney(totalAmt);
        trainGdxOrderBo.setOrderItemList(itemBoList);
        Long orderId = trainGdxOrderModel.createOrder(trainGdxOrderBo);
        return new TrainGdxCreateBatchOrderRspBo(orderId);
    }

    @Override
    public TrainGdxCreateOrderRspBo createOrder(TrainGdxCreateOrderReqBo reqBo) {
        //校验参数
        if (reqBo == null || reqBo.getGoodsId() == null || reqBo.getUserId() == null || reqBo.getNum() == null) {
            throw new BaseBusinessException("1001", "参数错误");
        }

        TrainGdxUserDo byId = trainGdxUserModel.getById(reqBo.getUserId());
        if (byId == null) {
            throw new BaseBusinessException("1002", "用户不存在");
        }

        TrainGdxGoodsDo trainGdxGoodsDo = trainGdxGoodsModel.getById(reqBo.getGoodsId());
        if (trainGdxGoodsDo == null) {
            throw new BaseBusinessException("1003", "商品不存在");
        }
        // 组装订单数据
        TrainGdxOrderBo trainGdxOrderBo = new TrainGdxOrderBo();
        trainGdxOrderBo.setOrderNo(DateUtil.format(new Date(), "yyyyMMddHHmmss"));
        trainGdxOrderBo.setOrderName(DateUtil.format(new Date(), "yyyy-MM-dd") + "的订单");
        trainGdxOrderBo.setOrderMoney(trainGdxGoodsDo.getGoodsPrice().multiply(new BigDecimal(reqBo.getNum())));
        trainGdxOrderBo.setCreateUserId(reqBo.getUserId());
        trainGdxOrderBo.setCreateUserName(byId.getUserName());
        trainGdxOrderBo.setCreateTime(new Date());
        trainGdxOrderBo.setOrderStatus(TrainOrderStatusEnum.O_000.getOrderStatus());
        TrainGdxOrderItemBo trainGdxOrderItemBo = new TrainGdxOrderItemBo();
        trainGdxOrderItemBo.setGoodsId(reqBo.getGoodsId());
        trainGdxOrderItemBo.setGoodsPrice(trainGdxGoodsDo.getGoodsPrice());
        trainGdxOrderItemBo.setCount(reqBo.getNum());
        trainGdxOrderItemBo.setTotalMoney(trainGdxGoodsDo.getGoodsPrice().multiply(new BigDecimal(reqBo.getNum())));
        trainGdxOrderBo.setOrderItemList(Lists.newArrayList(trainGdxOrderItemBo));
        Long orderId = trainGdxOrderModel.createOrder(trainGdxOrderBo);
        return new TrainGdxCreateOrderRspBo(orderId);
    }

    @Override
    public TrainGdxQueryOrderRspBo queryOrder(TrainGdxQueryOrderReqBo reqBo) {
        if (reqBo == null || reqBo.getOrderId() == null) {
            throw new BaseBusinessException("1005", "订单id不能为空");
        }

        TrainGdxOrderQryBo orderQryBo = new TrainGdxOrderQryBo();
        orderQryBo.setOrderId(reqBo.getOrderId());
        TrainGdxOrderBo trainGdxOrderBo = trainGdxOrderModel.queryOrder(orderQryBo);
        return BeanUtil.copyProperties(trainGdxOrderBo, TrainGdxQueryOrderRspBo.class);
    }


    @Override
    public TrainGdxUpdateRspBo updateOrder(TrainGdxUpdateOrderReqBo reqBo) {
        trainGdxOrderModel.updateOrder(reqBo.getTrainGdxOrderBo());
        return new TrainGdxUpdateRspBo();
    }
}
