package com.tydic.train.service.gdx.task;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.train.model.gdx.task.TrainGdxProcessInstModel;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.gdx.task.bo.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/29 17:46
 */
@HTServiceImpl
@RequiredArgsConstructor
@Slf4j
public class TrainGdxBpmTaskServiceImpl implements TrainGdxBpmTaskService {

    private final TrainGdxProcessInstModel trainGdxProcessInstModel;

    @Override
    public TrainGdxBpmTaskCreateRspBo createTask(TrainGdxBpmTaskCreateReqBo reqBo) {
        if (reqBo == null || reqBo.getTrainProcess() == null) {
            throw new BaseBusinessException("1001", "参数错误");
        }
        trainGdxProcessInstModel.createTask(reqBo.getTrainProcess());
        return new TrainGdxBpmTaskCreateRspBo();
    }


    @Override
    public TrainGdxBpmFlowUpdateRspBo updateFlowTask(TrainGdxBpmFlowUpdateReqBo reqBo) {
        trainGdxProcessInstModel.updateFlowTask(reqBo.getTrainProcess());
        return new TrainGdxBpmFlowUpdateRspBo();
    }

    @Override
    public TrainGdxBpmTaskUpdateRspBo updateTask(TrainGdxBpmTaskUpdateReqBo reqBo) {
        trainGdxProcessInstModel.updateTask(reqBo.getTaskInstList());
        return new TrainGdxBpmTaskUpdateRspBo();
    }

    @Override
    public TrainGdxQueryBpmTaskRspBo queryFlowTask(TrainGdxQueryBpmTaskReqBo reqBo) {
        TrainGdxProcessInstBo trainGdxProcessInstBo = trainGdxProcessInstModel.queryFlowTask(reqBo.getFlowInstId(), reqBo.getObjId());
        return new TrainGdxQueryBpmTaskRspBo(trainGdxProcessInstBo);
    }

    @Override
    public TrainGdxSeizeBpmTaskRspBo seizeTask(TrainGdxSeizeBpmTaskReqBo reqBo) {
        TrainGdxProcessInstBo trainGdxProcessInstBo = trainGdxProcessInstModel.queryFlowTask(reqBo.getFlowInstId(), null);
        List<TrainGdxTaskInstBo> taskInstList = trainGdxProcessInstBo.getTaskInstList();
        if (CollectionUtil.isNotEmpty(taskInstList) && taskInstList.size() > 1) {
            List<String> taskIds = taskInstList.stream().filter(taskTemp -> !taskTemp.getTaskId().equals(reqBo.getTaskId()) && taskTemp.getStepStatus().equals(0)).map(TrainGdxTaskInstBo::getTaskId).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(taskIds)) {
                log.info("抢占删除 {}", JSON.toJSONString(taskIds));
                trainGdxProcessInstModel.deleteBatchTask(taskIds);
            }
        }
        return new TrainGdxSeizeBpmTaskRspBo();
    }
}
