package com.tydic.train.service.goods;

import com.alibaba.fastjson.JSONArray;
import com.tydic.train.model.goods.TrainYyfGoodsDO;
import com.tydic.train.model.goods.TrainYyfGoodsModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.goods.bo.TrainYyfGoodsBO;
import com.tydic.train.service.goods.bo.TrainYyfQryGoodsInfoReqBO;
import com.tydic.train.service.goods.bo.TrainYyfQryGoodsInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@HTServiceImpl
public class TrainYyfQryGoodsInfoServiceImpl implements TrainYyfQryGoodsInfoService {

    @Autowired
    private TrainYyfGoodsModel trainYyfGoodsModel;

    @Override
    public TrainYyfQryGoodsInfoRspBO qryGoodsInfo(TrainYyfQryGoodsInfoReqBO reqBO) {
        TrainYyfQryGoodsInfoRspBO rspBo = new TrainYyfQryGoodsInfoRspBO();
        TrainYyfGoodsDO trainYyfGoodsQryBo = new TrainYyfGoodsDO();
        BeanUtils.copyProperties(reqBO, trainYyfGoodsQryBo);
        List<TrainYyfGoodsDO> goodsBOList = trainYyfGoodsModel.qryGoodsInfoList(reqBO.getGoodsIdList());
        if (!CollectionUtils.isEmpty(goodsBOList)) {
            List<TrainYyfGoodsBO> goodsInfo = new ArrayList<>();
            goodsInfo = JSONArray.parseArray(JSONArray.toJSONString(goodsBOList), TrainYyfGoodsBO.class);
            rspBo.setGoodsBOList(goodsInfo);
        }
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }
}
