package com.tydic.train.service.goods;

import com.tydic.train.model.goods.TrainZyyGoodsModel;
import com.tydic.train.model.goods.qrybo.TrainZyyGoodsQryBo;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.goods.bo.TrainZyyGoodsBO;
import com.tydic.train.service.goods.bo.TrainZyyQryGoodsInfoReqBO;
import com.tydic.train.service.goods.bo.TrainZyyQryGoodsInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题：TrainZyyQryGoodsInfoServiceImpl
 * 说明：周钰焱训练查询商品信息服务
 * 时间：2023/8/28 19:25
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class TrainZyyQryGoodsInfoServiceImpl implements TrainZyyQryGoodsInfoService {
    @Autowired
    private TrainZyyGoodsModel trainZyyGoodsModel;

    @Override
    public TrainZyyQryGoodsInfoRspBO qryGoodsInfo(TrainZyyQryGoodsInfoReqBO reqBO) {

        TrainZyyQryGoodsInfoRspBO rspBo = new TrainZyyQryGoodsInfoRspBO();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        TrainZyyGoodsQryBo trainZyyGoodsQryBo = new TrainZyyGoodsQryBo();
        BeanUtils.copyProperties(reqBO, trainZyyGoodsQryBo);
        List<TrainZyyGoodsBO> goodsBOList = trainZyyGoodsModel.qryGoodsInfoList(trainZyyGoodsQryBo);
        rspBo.setGoodsBOList(goodsBOList);

        return rspBo;
    }
}
