package com.tydic.train.service.lj;

import cn.hutool.core.bean.BeanUtil;
import com.tydic.train.model.lj.goods.TrainLjGoodsInfoDo;
import com.tydic.train.model.lj.goods.TrainLjGoodsInfoQryModel;
import com.tydic.train.model.lj.user.TrainLjUserInfoDo;
import com.tydic.train.service.lj.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @desc：
 * @author： liujian
 * @date： 2023/8/31 10:58
 **/
@HTServiceImpl
public class TrainLjGoodsInfoQryServiceImpl implements TrainLjGoodsInfoQryService {

    @Autowired
    private TrainLjGoodsInfoQryModel trainLjGoodsInfoQryModel;

    @Override
    public TrainLjGoodsInfoQryServiceRspBO qryGoodsInfo(TrainLjGoodsInfoQryServiceReqBO reqBO) {
        TrainLjGoodsInfoQryServiceRspBO rspBO = new TrainLjGoodsInfoQryServiceRspBO();
        TrainLjGoodsInfoQryServiceReqBO trainLjGoodsInfoQryServiceReqBO = new TrainLjGoodsInfoQryServiceReqBO();
        trainLjGoodsInfoQryServiceReqBO.setGoodsIds(reqBO.getGoodsIds());
        List<TrainLjGoodsInfoDo> trainLjGoodsInfoDos = trainLjGoodsInfoQryModel.qryGoodsInfo(trainLjGoodsInfoQryServiceReqBO);
        if (!CollectionUtils.isEmpty(trainLjGoodsInfoDos)){
            List<TrainLjGoodsInfoBO> trainLjGoodInfoBOS = new ArrayList<>(trainLjGoodsInfoDos.size());
            trainLjGoodsInfoDos.forEach(bo -> {
                TrainLjGoodsInfoBO trainLjGoodsInfoBO = BeanUtil.copyProperties(bo, TrainLjGoodsInfoBO.class);
                trainLjGoodInfoBOS.add(trainLjGoodsInfoBO);
            });
            rspBO.setRows(trainLjGoodInfoBOS);
        }
        return rspBO;
    }
}