package com.tydic.train.service.lj;

import cn.hutool.core.bean.BeanUtil;
import com.tydic.train.model.lj.user.TrainLjUserInfoDo;
import com.tydic.train.model.lj.user.TrainLjUserInfoQryModel;
import com.tydic.train.service.lj.bo.TrainLjUserInfoBO;
import com.tydic.train.service.lj.bo.TrainLjUserInfoQryServiceReqBO;
import com.tydic.train.service.lj.bo.TrainLjUserInfoQryServiceRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

import static org.springframework.beans.BeanUtils.*;

/**
 * @desc：
 * @author： liujian
 * @date： 2023/8/29 18:09
 **/
@HTServiceImpl
public class TrainLjUserInfoQryServiceImpl implements TrainLjUserInfoQryService {

    @Autowired
    private TrainLjUserInfoQryModel trainLjUserInfoQryModel;

    @Override
    public TrainLjUserInfoQryServiceRspBO qryUserInfo(TrainLjUserInfoQryServiceReqBO reqBO) {
        TrainLjUserInfoQryServiceRspBO rspBO = new TrainLjUserInfoQryServiceRspBO();
        TrainLjUserInfoQryServiceReqBO trainLjUserInfoQryServiceReqBO = new TrainLjUserInfoQryServiceReqBO();
        trainLjUserInfoQryServiceReqBO.setUserIds(reqBO.getUserIds());
        List<TrainLjUserInfoDo> trainLjUserInfoDos = trainLjUserInfoQryModel.qryUserInfo(trainLjUserInfoQryServiceReqBO);
        if (!CollectionUtils.isEmpty(trainLjUserInfoDos)){
            List<TrainLjUserInfoBO> trainLjUserInfoBOS = new ArrayList<>(trainLjUserInfoDos.size());
            trainLjUserInfoDos.forEach(bo -> {
                TrainLjUserInfoBO trainLjUserInfoBO = BeanUtil.copyProperties(bo, TrainLjUserInfoBO.class);
                trainLjUserInfoBOS.add(trainLjUserInfoBO);
            });
            rspBO.setRows(trainLjUserInfoBOS);
        }
        return rspBO;
    }
}