package com.tydic.train.service.lsq.order;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.lsq.goods.ITrainLsqGoodsModel;
import com.tydic.train.model.lsq.goods.TrainLsqGoodsDO;
import com.tydic.train.model.lsq.order.ITrainLsqOrderModel;
import com.tydic.train.model.lsq.order.TrainLsqOrderDO;
import com.tydic.train.model.lsq.order.sub.TrainLsqOrderItemDO;
import com.tydic.train.model.lsq.user.ITrainLsqUserModel;
import com.tydic.train.model.lsq.user.TrainLsqUserDO;
import com.tydic.train.service.lsq.order.bo.TrainLsqCreateOrderBO;
import com.tydic.train.service.lsq.order.bo.TrainLsqCreateOrderReqBO;
import com.tydic.train.service.lsq.order.bo.TrainLsqCreateOrderRspBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

/**
 * 类名： TrainLsqCreateOrderServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2023/8/28 16:10
 */
@HTServiceImpl
public class TrainLsqCreateOrderServiceImpl implements TrainLsqCreateOrderService {

    @Autowired
    private ITrainLsqUserModel iTrainLsqUserModel;

    @Autowired
    private ITrainLsqGoodsModel iTrainLsqGoodsModel;

    @Autowired
    private ITrainLsqOrderModel iTrainLsqOrderModel;

    private static final Integer not_del = 0;

    @Override
    public TrainLsqCreateOrderRspBO createOrder(TrainLsqCreateOrderReqBO reqBO) {
        // 参数校验
        this.verifyParam(reqBO);

        TrainLsqCreateOrderRspBO rspBO = new TrainLsqCreateOrderRspBO();

        // 校验用户是否存在
        TrainLsqUserDO userDO = new TrainLsqUserDO();
        userDO.setUserId(reqBO.getUserId());
        TrainLsqUserDO userDetail =iTrainLsqUserModel.qryUserDetail(userDO);
        if (ObjectUtil.isEmpty(userDetail)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("用户不存在");
            return rspBO;
        }
        // 详情集合
        List<TrainLsqOrderItemDO> insertBatchOrderItemDO = new ArrayList<>();
        BigDecimal totalMoney = BigDecimal.ZERO;
        for (TrainLsqCreateOrderBO goodsItem : reqBO.getOrderBOS()) {
            // 校验商品是否存在
            TrainLsqGoodsDO goodsDO = new TrainLsqGoodsDO();
            goodsDO.setGoodsId(goodsItem.getGoodsId());
            TrainLsqGoodsDO goodsDetail =iTrainLsqGoodsModel.qryGoodsDetail(goodsDO);
            if (ObjectUtil.isEmpty(goodsDetail)) {
                rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
                rspBO.setRespDesc("商品不存在");
                return rspBO;
            }
            totalMoney = totalMoney.add(goodsDetail.getGoodsPrice().multiply(new BigDecimal(goodsItem.getCount())));

            // 新增订单详情
            TrainLsqOrderItemDO insertOrderItemDO = new TrainLsqOrderItemDO();
            insertOrderItemDO.setGoodsId(goodsDetail.getGoodsId());
            insertOrderItemDO.setGoodsPrice(goodsDetail.getGoodsPrice());
            insertOrderItemDO.setCount(goodsItem.getCount());
            insertOrderItemDO.setTotalMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(goodsItem.getCount())));
            insertOrderItemDO.setDelFlag(not_del);
            insertBatchOrderItemDO.add(insertOrderItemDO);
        }


        // 新增订单
        TrainLsqOrderDO insertOrderDO = new TrainLsqOrderDO();
        insertOrderDO.setOrderNo(createOrderNo());
        insertOrderDO.setOrderName(DateUtil.format(new Date(), "yyyy-MM-dd")+userDetail.getUserName() + "的订单");
        insertOrderDO.setOrderMoney(totalMoney);
        insertOrderDO.setCreateUserId(userDetail.getUserId());
        insertOrderDO.setCreateUserName(userDetail.getUserName());
        insertOrderDO.setCreateTime(new Date());
        insertOrderDO.setDelFlag(not_del);
        Long orderId = iTrainLsqOrderModel.insertOrder(insertOrderDO);


        // 新增订单详情
        insertBatchOrderItemDO.forEach(item -> item.setOrderId(orderId));
        iTrainLsqOrderModel.insertBatchOrderItem(insertBatchOrderItemDO);

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBO.setOrderId(orderId);
        return rspBO;
    }

    /**
     * 生成建议单编号
     * @return
     */
    public static String createOrderNo() {
        // 获取当前时间
        Date now = new Date();
        // 设置日期格式为yyyyMMddHHmmss
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = sdf.format(now);

        // 生成4位随机数
        Random random = new Random();
        int randomNumber = random.nextInt(9000) + 1000;

        // 拼接编码
        String code = "LSQ_DD" + timestamp + randomNumber;

        return code;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(TrainLsqCreateOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("下单入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getUserId())) {
            throw new ZTBusinessException("下单入参用户ID为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getOrderBOS())) {
            throw new ZTBusinessException("下单入参创建订单集合为空");
        }
    }
}
