package com.tydic.train.service.lsq.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.train.model.lsq.goods.ITrainLsqGoodsModel;
import com.tydic.train.model.lsq.goods.TrainLsqGoodsDO;
import com.tydic.train.model.lsq.order.ITrainLsqOrderModel;
import com.tydic.train.model.lsq.order.TrainLsqOrderDO;
import com.tydic.train.model.lsq.order.sub.TrainLsqOrderItemDO;
import com.tydic.train.model.lsq.user.ITrainLsqUserModel;
import com.tydic.train.model.lsq.user.TrainLsqUserDO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.lsq.order.bo.*;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： TrainLsqQueryOrderServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2023/8/28 21:27
 */
@HTServiceImpl
public class TrainLsqQueryOrderServiceImpl implements TrainLsqQueryOrderService {

    @Autowired
    private ITrainLsqUserModel iTrainLsqUserModel;

    @Autowired
    private ITrainLsqOrderModel iTrainLsqOrderModel;

    @Autowired
    private ITrainLsqGoodsModel iTrainLsqGoodsModel;

    @Override
    public TrainLsqQueryOrderRspBO queryOrder(TrainLsqQueryOrderReqBO reqBO) {
        TrainLsqQueryOrderRspBO rspBO = new TrainLsqQueryOrderRspBO();
        TrainLsqOrderDO qryDO = new TrainLsqOrderDO();
        qryDO.setOrderId(reqBO.getOrderId());
        // 查询订单信息
        TrainLsqOrderDO detailDO = iTrainLsqOrderModel.qryOrderDetail(qryDO);
        rspBO = JSONObject.parseObject(JSON.toJSONString(detailDO),TrainLsqQueryOrderRspBO.class);
        rspBO.setOrderItemBOS(JsonUtil.jsl(detailDO.getItemDOS(),TrainLsqOrderItemBO.class));
        // 查询商品信息
        TrainLsqGoodsDO qryGoodsDO = new TrainLsqGoodsDO();
        if (!CollectionUtils.isEmpty(detailDO.getItemDOS())){
            List<TrainLsqGoodsBO> goodsBOS = new ArrayList<>();
            for (TrainLsqOrderItemDO orderItemDO :detailDO.getItemDOS()) {
                qryGoodsDO.setGoodsId(orderItemDO.getGoodsId());
                TrainLsqGoodsDO goodsDO = iTrainLsqGoodsModel.qryGoodsDetail(qryGoodsDO);
                if (ObjectUtil.isNotEmpty(goodsDO)) {
                    goodsBOS.add(JsonUtil.js(goodsDO,TrainLsqGoodsBO.class));
                }
                rspBO.setGoodsBOS(goodsBOS);
            }
        }


        // 查询用户信息
        TrainLsqUserDO qryUserDO = new TrainLsqUserDO();
        qryUserDO.setUserId(detailDO.getCreateUserId());
        TrainLsqUserDO userDO = iTrainLsqUserModel.qryUserDetail(qryUserDO);
        if (ObjectUtil.isNotEmpty(userDO)) {
            rspBO.setUserBO(JSONObject.parseObject(JSON.toJSONString(userDO), TrainLsqUserBO.class));
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
