package com.tydic.train.service.lsq.order;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.lsq.order.ITrainLsqOrderModel;
import com.tydic.train.model.lsq.order.TrainLsqOrderDO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.lsq.order.bo.TrainLsqUpdateOrderReqBO;
import com.tydic.train.service.lsq.order.bo.TrainLsqUpdateOrderRspBO;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： TrainLsqUpdateOrderServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2023/8/29 19:36
 */
@HTServiceImpl
public class TrainLsqUpdateOrderServiceImpl implements TrainLsqUpdateOrderService {

    @Autowired
    private ITrainLsqOrderModel iTrainLsqOrderModel;

    @Override
    public TrainLsqUpdateOrderRspBO updateOrder(TrainLsqUpdateOrderReqBO reqBO) {
        TrainLsqUpdateOrderRspBO rspBO = new TrainLsqUpdateOrderRspBO();
        // 参数校验
        this.verifyParam(reqBO);

        // 查询订单是否存在
        TrainLsqOrderDO qryDO = new TrainLsqOrderDO();
        qryDO.setOrderId(reqBO.getOrderId());
        TrainLsqOrderDO orderDetail = iTrainLsqOrderModel.qryOrderDetail(qryDO);
        if (ObjectUtil.isEmpty(orderDetail)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("订单不存在");
            return rspBO;
        }

        TrainLsqOrderDO updateDO = JsonUtil.js(reqBO,TrainLsqOrderDO.class);
        iTrainLsqOrderModel.updateOrder(updateDO);

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(TrainLsqUpdateOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("订单修改入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getOrderId())) {
            throw new ZTBusinessException("订单修改入参订单ID为空");
        }
    }
}
