package com.tydic.train.service.lyandyyf;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.train.model.lsq.approval.TrainLsqProcessInstDO;
import com.tydic.train.model.lsq.approval.sub.TrainLsqTaskInstDO;
import com.tydic.train.model.lyandyyf.TrainLYTaskInstModel;
import com.tydic.train.model.lyandyyf.TrainProcessInstModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.lsq.approval.bo.TrainLsqCreateApprovalRspBO;
import com.tydic.train.service.lsq.approval.bo.TrainLsqTaskInstBO;
import com.tydic.train.service.ly.task.TrainLYInsAndTaskCreateService;
import com.tydic.train.service.ly.task.bo.*;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题：TrainLYInsAndTaskCreateServiceImpl
 * 说明：
 * 时间： 2023-08-30 22:13
 * 作者 @author LY
 */
@HTServiceImpl
public class TrainLYInsAndTaskCreateServiceImpl implements TrainLYInsAndTaskCreateService {

    private TrainProcessInstModel trainProcessInstModel;

    private TrainLYTaskInstModel trainLYTaskInstModel;

    public TrainLYInsAndTaskCreateServiceImpl(TrainProcessInstModel trainProcessInstModel, TrainLYTaskInstModel trainLYTaskInstModel) {
        this.trainProcessInstModel = trainProcessInstModel;
        this.trainLYTaskInstModel = trainLYTaskInstModel;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TrainLYInsAndTaskCreateRspBO createInstTask(TrainLYInsAndTaskCreateReqBO reqBO) {
        if(null == reqBO.getTrainLYProcessInstBO()){
            return new TrainLYInsAndTaskCreateRspBO();
        }

        TrainLYProcessInstReqBO processInstReqBO = new TrainLYProcessInstReqBO();
        processInstReqBO.setProcInstId(reqBO.getTrainLYProcessInstBO().getProcInstId());
        TrainLYProcessInstRspBO trainLYProcessInstRspBO = trainProcessInstModel.queryTrainProcessInstSingle(processInstReqBO);
        TrainLYProcessInstReqBO trainLYProcessInstReqBO = new TrainLYProcessInstReqBO();
        BeanUtils.copyProperties(reqBO.getTrainLYProcessInstBO(),trainLYProcessInstReqBO);
        if(null == trainLYProcessInstRspBO || trainLYProcessInstRspBO.getData() == null){
            trainProcessInstModel.addTrainProcessInst(trainLYProcessInstReqBO);
        }else {
            trainProcessInstModel.updateTrainProcessInst(trainLYProcessInstReqBO);
        }
        if(!CollectionUtils.isEmpty(reqBO.getTrainLYTaskInstBOS())) {
            List<TrainLYTaskInstReqBO> taskInstReqBOS = JSON.parseArray(JSON.toJSONString(reqBO.getTrainLYTaskInstBOS()), TrainLYTaskInstReqBO.class);
            trainLYTaskInstModel.addListTrainTaskInst(taskInstReqBOS);
        }
        return new TrainLYInsAndTaskCreateRspBO();
    }

    @Override
    public TrainYyfCreateApprovalRspBO updateInstTask(TrainYyfCreateApprovalReqBO reqBO) {
        TrainYyfCreateApprovalRspBO rspBO = new TrainYyfCreateApprovalRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        if (Boolean.TRUE.equals(reqBO.getIsfinish())){
            // 修改流程实例
            TrainLYProcessInstReqBO updateProcessInstDO = new TrainLYProcessInstReqBO();
            updateProcessInstDO.setDelFlag(1);
            updateProcessInstDO.setIsFinish(1);
            updateProcessInstDO.setProcInstId(reqBO.getProcInstId());
            trainProcessInstModel.updateTrainProcessInst(updateProcessInstDO);
        }
        for (TrainLYTaskInstBO taskInstBO : reqBO.getTaskInstList()) {
            // 修改实例任务
            TrainLYTaskInstReqBO updateTaskInstDO = new TrainLYTaskInstReqBO();
            updateTaskInstDO.setProcInstId(taskInstBO.getProcInstId());
            updateTaskInstDO.setDelFlag(1);
            updateTaskInstDO.setStepStatus(1);
            trainLYTaskInstModel.updateTrainTaskInst(updateTaskInstDO);
        }
        return new TrainYyfCreateApprovalRspBO();
    }
}
