package com.tydic.train.service.lyandyyf;

import com.tydic.train.model.order.TrainYyfOrderDo;
import com.tydic.train.model.order.TrainYyfOrderModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.ly.order.TrainYyfShipGoodsService;
import com.tydic.train.service.ly.order.bo.TrainYyfShipGoodsReqBO;
import com.tydic.train.service.ly.order.bo.TrainYyfShipGoodsRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;


@HTServiceImpl
public class TrainYyfShipGoodsServiceImpl implements TrainYyfShipGoodsService {

    @Autowired
    private TrainYyfOrderModel trainYyfOrderModel;

    @Override
    public TrainYyfShipGoodsRspBO shipGoods(TrainYyfShipGoodsReqBO reqBO) {
        TrainYyfShipGoodsRspBO rspBO = new TrainYyfShipGoodsRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        TrainYyfOrderDo trainYyfOrderDo = trainYyfOrderModel.shipGoods(reqBO);
        rspBO.setOrderId(trainYyfOrderDo.getOrderId());
        return rspBO;
    }
}
