package com.tydic.train.service.lyandyyf;

import com.tydic.train.model.lyandyyf.TrainYyfShipOrderItemModel;
import com.tydic.train.service.ly.ship.TrainYyfShipOrderItemService;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemListRspBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemReqBO;
import com.tydic.train.service.ly.ship.bo.TrainYyfShipOrderItemRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名：TrainYyfShipOrderItemServiceImpl
 * 标题：
 * 说明：
 * 时间：2023/8/31 10:35
 *
 * @author yangyf
 **/
@HTServiceImpl
public class TrainYyfShipOrderItemServiceImpl implements TrainYyfShipOrderItemService {

    @Autowired
    private TrainYyfShipOrderItemModel trainYyfShipOrderItemModel;

    /**
     * 描述:查询信息（单个）
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO queryTrainShipOrderItemSingle(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemModel.queryTrainShipOrderItemSingle(reqBO);
    }

    /**
     * 描述:查询信息列表
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemListRspBO queryTrainShipOrderItemList(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemModel.queryTrainShipOrderItemList(reqBO);
    }

    /**
     * 描述:新增信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO addTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemModel.addTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:新增多条信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemListRspBO addListTrainShipOrderItem(List<TrainYyfShipOrderItemReqBO> reqBO) {
        return trainYyfShipOrderItemModel.addListTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:修改信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO updateTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemModel.updateTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:保存信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO saveTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemModel.saveTrainShipOrderItem(reqBO);
    }

    /**
     * 描述:删除信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderItemReqBO
     * @return: TrainYyfShipOrderItemRspBO
     * @author: yangyf
     * @date: 2023-08-31 09:45:46
     */
    @Override
    public TrainYyfShipOrderItemRspBO deleteTrainShipOrderItem(TrainYyfShipOrderItemReqBO reqBO) {
        return trainYyfShipOrderItemModel.deleteTrainShipOrderItem(reqBO);
    }
}
