package com.tydic.train.service.lyandyyf;

import com.tydic.train.model.lyandyyf.TrainYyfShipOrderModel;
import com.tydic.train.service.ly.ship.TrainYyfShipOrderService;
import com.tydic.train.service.ly.ship.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 类名：TrainYyfShipOrderItemServiceImpl
 * 标题：
 * 说明：
 * 时间：2023/8/31 10:35
 *
 * @author yangyf
 **/
@HTServiceImpl
public class TrainYyfShipOrderServiceImpl implements TrainYyfShipOrderService {

    @Autowired
    private TrainYyfShipOrderModel trainYyfShipOrderModel;

    /**
     * 描述:查询信息（单个）
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO queryTrainShipOrderSingle(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderModel.queryTrainShipOrderSingle(reqBO);
    }

    /**
     * 描述:查询信息列表
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderListRspBO queryTrainShipOrderList(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderModel.queryTrainShipOrderList(reqBO);
    }

    /**
     * 描述:新增信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO addTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderModel.addTrainShipOrder(reqBO);
    }

    /**
     * 描述:新增多条信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderListRspBO addListTrainShipOrder(List<TrainYyfShipOrderReqBO> reqBO) {
        return trainYyfShipOrderModel.addListTrainShipOrder(reqBO);
    }

    /**
     * 描述:修改信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO updateTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderModel.updateTrainShipOrder(reqBO);
    }

    /**
     * 描述:保存信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO saveTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderModel.saveTrainShipOrder(reqBO);
    }

    /**
     * 描述:删除信息
     *
     * @param reqBO
     * @throws
     * @param: TrainYyfShipOrderReqBO
     * @return: TrainYyfShipOrderRspBO
     * @author: zhoulu
     * @date: 2023-08-31 10:37:46
     */
    @Override
    public TrainYyfShipOrderRspBO deleteTrainShipOrder(TrainYyfShipOrderReqBO reqBO) {
        return trainYyfShipOrderModel.deleteTrainShipOrder(reqBO);
    }
}
