package com.tydic.train.service.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.commodity.TrainHWCommodityDo;
import com.tydic.train.model.commodity.TrainHWCommodityModel;
import com.tydic.train.model.order.TrainHWOrderCreateDo;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.user.TrainHWUserDo;
import com.tydic.train.model.user.TrainHWUserModel;
import com.tydic.train.service.order.bo.TrainHWOrderGoodsBo;
import com.tydic.train.service.order.bo.TrainHWOrderQryReqBO;
import com.tydic.train.service.order.bo.TrainHWOrderQryRspBO;
import com.tydic.train.utils.JsonUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWOrderQryServiceImpl
 * @ClassName TrainHWOrderQryServiceImpl
 * @date 2023/8/29 11:38
 */
@HTServiceImpl
public class TrainHWOrderQryServiceImpl implements TrainHWOrderQryService {
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Autowired
    private TrainHWUserModel trainHWUserModel;
    @Autowired
    private TrainHWCommodityModel trainHWCommodityModel;

    @Override
    public TrainHWOrderQryRspBO qryOrder(TrainHWOrderQryReqBO reqBO) {
        //订单及明细信息
        TrainHWOrderCreateDo createDo = trainHWOrderModel.qryOrder(reqBO.getOrderId());
        TrainHWOrderQryRspBO rspBO = JsonUtil.js(createDo, TrainHWOrderQryRspBO.class);
        //商品信息
        if (!CollectionUtils.isEmpty(createDo.getItemBos())) {
            List<Long> skuIds = createDo.getItemBos().stream().map(e -> e.getGoodsId()).collect(Collectors.toList());
            TrainHWCommodityDo hwCommodityDo = trainHWCommodityModel.qryGoodsByIds(skuIds);
            List<TrainHWOrderGoodsBo> goodsBos = hwCommodityDo.getCommoditySubBoList().stream()
                    .map(e -> JSONObject.parseObject(JSON.toJSONString(e), TrainHWOrderGoodsBo.class)).collect(Collectors.toList());
            rspBO.setSkuList(goodsBos);
        }
        //用户信息回填
        TrainHWUserDo trainHWUserDo = trainHWUserModel.qryUserById(rspBO.getCreateUserId());
        //订单状态
        rspBO.setOrderStatusStr(TrainHWRspConstant.OrderStatusEnum.getTranslation(rspBO.getOrderStatus()));
        rspBO.setOrgId(trainHWUserDo.getOrgId());
        rspBO.setOrgName(trainHWUserDo.getOrgName());
        rspBO.setOrgCode(trainHWUserDo.getOrgCode());
        return rspBO;
    }
}
