package com.tydic.train.service.order;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.order.TrainLHLOrderDO;
import com.tydic.train.model.order.TrainLHLOrderModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.TrainLHLOrderCreateReqBO;
import com.tydic.train.service.order.bo.TrainLHLOrderCreateRspBO;
import com.tydic.train.service.order.bo.TrainLHLOrderItemBO;
import com.tydic.train.utils.OrderGenerateIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.Date;

@HTServiceImpl
public class TrainLHLOrderCreateServiceImpl implements TrainLHLOrderCreateService {

    @Autowired
    private OrderGenerateIdUtil idUtil;

    @Autowired
    private TrainLHLOrderModel trainLHLOrderModel;

    @Override
    public TrainLHLOrderCreateRspBO orderCreate(TrainLHLOrderCreateReqBO reqBO) {

        TrainLHLOrderCreateRspBO rspBO = new TrainLHLOrderCreateRspBO();

        // 校验，组装数据
        judge(reqBO);

        // 新增订单
        TrainLHLOrderDO inserDO = new TrainLHLOrderDO();
        BeanUtils.copyProperties(reqBO, inserDO);
        trainLHLOrderModel.insert(inserDO);

        rspBO.setOrderId(reqBO.getOrderId());
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 校验，组装数据
     *
     * @param reqBO
     */
    private void judge(TrainLHLOrderCreateReqBO reqBO) {

        BigDecimal orderMoney = new BigDecimal(0);
        Date time = new Date(System.currentTimeMillis());

        reqBO.setOrderId(idUtil.nextId());

        if (reqBO == null) {
            throw new ZTBusinessException("订单主体新增不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getOrderDetailInfo())) {
            throw new ZTBusinessException("订单详情新增不能为空");
        }

        if (StringUtils.isEmpty(reqBO.getOrderNo())) {
            throw new ZTBusinessException("订单编号不能为空");
        }
        if (StringUtils.isEmpty(reqBO.getOrderName())) {
            throw new ZTBusinessException("订单名称不能为空");
        }
        for (TrainLHLOrderItemBO each : reqBO.getOrderDetailInfo()) {

            each.setItemId(idUtil.nextId());
            each.setOrderId(reqBO.getOrderId());

            if (each.getGoodsId() == null) {
                throw new ZTBusinessException("商品ID不能为空");
            }
            if (each.getGoodsPrice() == null) {
                throw new ZTBusinessException("商品价格不能为空");
            }
            if (each.getCount() == null) {
                throw new ZTBusinessException("购买数量");
            }
            if (each.getTotalMoney() == null) {
                each.setTotalMoney(each.getGoodsPrice().multiply(new BigDecimal(each.getCount())));
            }

            orderMoney = orderMoney.add(each.getTotalMoney());
            each.setDelFlag(0);

        }

        // 组装数据
        reqBO.setOrderMoney(orderMoney);
        if (reqBO.getCreateUserId() == null) {
            reqBO.setCreateUserId(reqBO.getUserId());
            reqBO.setCreateUserName(reqBO.getUsername());
        }
        reqBO.setCreateTime(time);
        reqBO.setDelFlag(0);

    }
}
