package com.tydic.train.service.order;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.order.TrainLHLOrderDO;
import com.tydic.train.model.order.TrainLHLOrderModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.TrainLHLOrderDetailQryReqBO;
import com.tydic.train.service.order.bo.TrainLHLOrderDetailQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class TrainLHLOrderDetailQryServiceImpl implements TrainLHLOrderDetailQryService {

    @Autowired
    private TrainLHLOrderModel trainLHLOrderModel;

    @Override
    public TrainLHLOrderDetailQryRspBO orderDetailQry(TrainLHLOrderDetailQryReqBO reqBO) {
        TrainLHLOrderDetailQryRspBO rspBO = new TrainLHLOrderDetailQryRspBO();

        if (reqBO.getOrderId() == null) {
            throw new ZTBusinessException("订单id不能为空");
        }

        TrainLHLOrderDO trainLHLOrderDO = trainLHLOrderModel.qryOrder(reqBO.getOrderId());
        if (trainLHLOrderDO != null) {
            BeanUtils.copyProperties(trainLHLOrderDO, rspBO);
        }


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
