package com.tydic.train.service.order;

import com.tydic.train.model.order.TrainLYOrderModel;
import com.tydic.train.model.order.bo.TrainLYOrderRepositoryRspBO;
import com.tydic.train.service.order.bo.TrainLYCreateOrderReqBO;
import com.tydic.train.service.order.bo.TrainLYCreateOrderRspBO;
import com.tydic.train.service.order.bo.TrainLYUpdateOrderReqBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 标题：TrainLYCreateOrderServiceImpl
 * 说明：
 * 时间： 2023-08-29 20:36
 * 作者 @author LY
 */
@HTServiceImpl
public class TrainLYCreateOrderServiceImpl implements TrainLYCreateOrderService{

    private TrainLYOrderModel trainLYOrderModel;

    public TrainLYCreateOrderServiceImpl(TrainLYOrderModel trainLYOrderModel) {
        this.trainLYOrderModel = trainLYOrderModel;
    }

    @Override
    public TrainLYCreateOrderRspBO createOrder(TrainLYCreateOrderReqBO reqBO) {
        TrainLYCreateOrderRspBO rspBO = new TrainLYCreateOrderRspBO();
        TrainLYOrderRepositoryRspBO order = trainLYOrderModel.createOrder(reqBO);
        rspBO.setOrderId(order.getOrderId());
        return rspBO;
    }

    @Override
    public TrainLYCreateOrderRspBO updateOrderStatus(TrainLYUpdateOrderReqBO reqBO) {
        return trainLYOrderModel.updateOrderStatus(reqBO);
    }
}
