package com.tydic.train.service.order;

import com.alibaba.fastjson.JSON;
import com.tydic.train.model.order.TrainLYOrderModel;
import com.tydic.train.model.order.bo.TrainLYOrderRepositoryReqBO;
import com.tydic.train.model.order.bo.TrainLYOrderRepositoryRspBO;
import com.tydic.train.service.order.bo.TrainLYOrderQryReqBO;
import com.tydic.train.service.order.bo.TrainLYOrderQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.stereotype.Service;

/**
 * 标题：TrainLYOrderQryServiceImpl
 * 说明：
 * 时间： 2023-08-29 15:10
 * 作者 @author LY
 */
@HTServiceImpl
public class TrainLYOrderQryServiceImpl implements TrainLYOrderQryService{

    private TrainLYOrderModel trainLYOrderModel;

    public TrainLYOrderQryServiceImpl(TrainLYOrderModel trainLYOrderModel) {
        this.trainLYOrderModel = trainLYOrderModel;
    }

    @Override
    public TrainLYOrderQryRspBO qryOrder(TrainLYOrderQryReqBO reqBO) {
        TrainLYOrderRepositoryReqBO trainLYOrderRepositoryReqBO = new TrainLYOrderRepositoryReqBO();
        trainLYOrderRepositoryReqBO.setOrderId(reqBO.getOrderId());
        TrainLYOrderRepositoryRspBO orderRepositoryRspBO = trainLYOrderModel.qryOrder(trainLYOrderRepositoryReqBO);
        TrainLYOrderQryRspBO rspBO = JSON.parseObject(JSON.toJSONString(orderRepositoryRspBO),TrainLYOrderQryRspBO.class);
        return rspBO;
    }
}
