package com.tydic.train.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.goods.TrainYyfGoodsDO;
import com.tydic.train.model.goods.TrainYyfGoodsModel;
import com.tydic.train.model.order.TrainYyfOrderDo;
import com.tydic.train.model.order.TrainYyfOrderItemDo;
import com.tydic.train.model.order.TrainYyfOrderModel;
import com.tydic.train.model.user.TrainYyfUserDO;
import com.tydic.train.model.user.TrainYyfUserModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.*;
import com.tydic.train.utils.TrainTfqIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@HTServiceImpl
public class TrainYyfCreateOrderServiceImpl implements TrainYyfCreateOrderService {

    @Autowired
    private TrainYyfOrderModel trainYyfOrderModel;

    @Autowired
    private TrainYyfUserModel trainYyfUserModel;

    @Autowired
    private TrainYyfGoodsModel trainYyfGoodsModel;

    @Override
    public TrainYyfCreateOrderRspBO createOrder(TrainYyfCreateOrderReqBO reqBO) {
//        参数校验
        verifyParam(reqBO);

        TrainYyfCreateOrderRspBO rspBo = new TrainYyfCreateOrderRspBO();
        // 校验用户是否存在
        TrainYyfUserDO userDO = new TrainYyfUserDO();
        userDO.setUserId(reqBO.getUserId());
        TrainYyfUserDO userDetail =trainYyfUserModel.qryUserDetail(userDO);
        if (ObjectUtil.isEmpty(userDetail)) {
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBo.setRespDesc("用户不存在");
            return rspBo;
        }

        // 校验商品是否存在
        TrainYyfGoodsDO goodsDO = new TrainYyfGoodsDO();
        goodsDO.setGoodsId(reqBO.getGoodsId());
        TrainYyfGoodsDO goodsDetail =trainYyfGoodsModel.qryGoodsDetail(goodsDO);
        if (ObjectUtil.isEmpty(goodsDetail)) {
            rspBo.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBo.setRespDesc("商品不存在");
            return rspBo;
        }

        TrainYyfOrderDo insertOrderDO = new TrainYyfOrderDo();

        insertOrderDO.setOrderNo(TrainTfqIdUtil.nextId()+"YYF");
        insertOrderDO.setOrderName("YYF的订单");
        insertOrderDO.setOrderMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderDO.setCreateUserId(userDetail.getUserId());
        insertOrderDO.setCreateUserName(userDetail.getUserName());
        insertOrderDO.setCreateTime(new Date());
        insertOrderDO.setDelFlag(0);

        // 增加订单明细
        List<TrainYyfOrderItemDo> insertOrderItemDOList = new ArrayList<>();
        TrainYyfOrderItemDo insertOrderItemDO = new TrainYyfOrderItemDo();
        insertOrderItemDO.setItemId(TrainTfqIdUtil.nextId());
        insertOrderItemDO.setCount(reqBO.getCount());
        insertOrderItemDO.setGoodsId(goodsDetail.getGoodsId());
        insertOrderItemDO.setTotalMoney(goodsDetail.getGoodsPrice());
        insertOrderItemDO.setDelFlag(0);
        insertOrderItemDOList.add(insertOrderItemDO);

        insertOrderDO.setItemList(insertOrderItemDOList);
        Long orderId = trainYyfOrderModel.insertOrder(insertOrderDO);
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBo.setOrderId(orderId);
        return rspBo;
    }

    private void verifyParam(TrainYyfCreateOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("下单入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getUserId())) {
            throw new ZTBusinessException("下单入参用户ID为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getGoodsId())) {
            throw new ZTBusinessException("下单入参商品ID为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCount())) {
            throw new ZTBusinessException("下单入参购买数量为空");
        }
    }

}
