package com.tydic.train.service.order;

import com.alibaba.fastjson.JSONObject;
import com.tydic.train.model.goods.TrainYyfGoodsModel;
import com.tydic.train.model.goods.impl.TrainYyfGoodsModelImpl;
import com.tydic.train.model.order.TrainYyfOrderDo;
import com.tydic.train.model.order.TrainYyfOrderModel;
import com.tydic.train.model.user.TrainYyfUserDO;
import com.tydic.train.model.user.TrainYyfUserModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class TrainYyfOrderQryServiceImpl implements TrainYyfOrderQryService {


    @Autowired
    private TrainYyfOrderModel trainYyfOrderModel;

    @Override
    public TrainYyfOrderQryRspBo qryOrder(TrainYyfOrderQryReqBo reqBO) {
        TrainYyfOrderQryRspBo rspBo = new TrainYyfOrderQryRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        TrainYyfOrderDo trainYyfOrderDo = new TrainYyfOrderDo();
        BeanUtils.copyProperties(reqBO, trainYyfOrderDo);
        TrainYyfOrderDo selectOrderDo = trainYyfOrderModel.qryOrder(trainYyfOrderDo);
        rspBo = JSONObject.parseObject(JSONObject.toJSONString(selectOrderDo), TrainYyfOrderQryRspBo.class);
        return rspBo;
    }
}
