package com.tydic.train.service.order;

import com.tydic.train.model.order.TrainZyyOrderDo;
import com.tydic.train.model.order.TrainZyyOrderModel;
import com.tydic.train.model.order.qrybo.TrainZyyOrderQryBo;
import com.tydic.train.model.order.sub.TrainZyyOrderItemBO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.order.bo.TrainZyyShipGoodsItemBo;
import com.tydic.train.service.order.bo.TrainZyyShipGoodsReqBO;
import com.tydic.train.service.order.bo.TrainZyyShipGoodsRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：TrainZyyShipGoodsServiceImpl
 * 说明：发货服务实现
 * 时间：2023/8/29 20:59
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class TrainZyyShipGoodsServiceImpl implements TrainZyyShipGoodsService {
    @Autowired
    private TrainZyyOrderModel trainZyyOrderModel;

    @Override
    public TrainZyyShipGoodsRspBO shipGoods(TrainZyyShipGoodsReqBO reqBO) {
        TrainZyyShipGoodsRspBO rspBO = new TrainZyyShipGoodsRspBO();
        if (reqBO.getOrderId()==null){
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("请传入订单id");
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        if (CollectionUtils.isEmpty(reqBO.getShipGoodsItemBoList())){
            TrainZyyOrderQryBo trainZyyOrderQryBo = new TrainZyyOrderQryBo();
            trainZyyOrderQryBo.setOrderId(reqBO.getOrderId());
            TrainZyyOrderDo trainZyyOrderDo = trainZyyOrderModel.qryOrderInfoSingle(trainZyyOrderQryBo);
            if (trainZyyOrderDo!=null){
                reqBO.setShipUserId(trainZyyOrderDo.getCreateUserId());
                reqBO.setShipUserName(trainZyyOrderDo.getCreateUserName());
                List<TrainZyyShipGoodsItemBo> shipGoodsItemBoList = new ArrayList<>();
                List<TrainZyyOrderItemBO> trainZyyOrderItemBOS = trainZyyOrderDo.getOrderItemBOList();
                if (!CollectionUtils.isEmpty(trainZyyOrderItemBOS)){
                    for (TrainZyyOrderItemBO trainZyyOrderItemBO : trainZyyOrderItemBOS) {
                        TrainZyyShipGoodsItemBo trainZyyShipGoodsItemBo = new TrainZyyShipGoodsItemBo();
                        trainZyyShipGoodsItemBo.setGoodsId(trainZyyOrderItemBO.getGoodsId());
                        trainZyyShipGoodsItemBo.setItemId(trainZyyOrderItemBO.getItemId());
                        trainZyyShipGoodsItemBo.setOrderId(trainZyyOrderDo.getOrderId());
                        trainZyyShipGoodsItemBo.setShipCount(trainZyyOrderItemBO.getCount());
                        shipGoodsItemBoList.add(trainZyyShipGoodsItemBo);
                    }
                }
                reqBO.setShipGoodsItemBoList(shipGoodsItemBoList);
            }



        }
        TrainZyyOrderDo trainZyyOrderDo = trainZyyOrderModel.shipGoods(reqBO);
        return rspBO;
    }
}
