package com.tydic.train.service.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.order.TrainHWOrderModel;
import com.tydic.train.model.order.qrybo.TrainHWOrderChangeQryBO;
import com.tydic.train.model.workflow.TrainHWProcessTaskDo;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessProcInstQryBO;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.model.workflow.qryBo.TrainHWTaskQryBO;
import com.tydic.train.model.workflow.qryBo.TrainHWTaskUpdateQryBO;
import com.tydic.train.service.task.bo.TrainHWTaskDealReqBO;
import com.tydic.train.service.task.bo.TrainHWTaskDealRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWTaskDealServiceImpl
 * @ClassName TrainHWTaskDealServiceImpl
 * @date 2023/8/30 17:46
 */
@HTServiceImpl
public class TrainHWTaskDealServiceImpl implements TrainHWTaskDealService {
    @Autowired
    private TrainHWProcessTaskModel trainHWProcessTaskModel;
    @Autowired
    private TrainHWOrderModel trainHWOrderModel;
    @Value("${HW_ORDER_APPROVE_KEY:HW_APPROVE_BUSI_KEY}")
    private String HW_ORDER_APPROVE_KEY;


    @Override
    public TrainHWTaskDealRspBO dealTask(TrainHWTaskDealReqBO dealReqBO) {
        //查询是否存在流程任务 存在不操作  不存在新增
        TrainHWProcessTaskQryBo taskQryBo = new TrainHWProcessTaskQryBo();
        taskQryBo.setProcInstId(dealReqBO.getProcInstId());
        TrainHWProcessTaskDo taskDo = trainHWProcessTaskModel.qryProcees(taskQryBo);
        if (CollectionUtils.isEmpty(taskDo.getTaskBoList())) {
            //新增流程任务
            TrainHWProcessProcInstQryBO processProcInstQryBO =
                    JSONObject.parseObject(JSON.toJSONString(dealReqBO), TrainHWProcessProcInstQryBO.class);
            trainHWProcessTaskModel.addProcInst(processProcInstQryBO);
            //新增流程实例表
            List<TrainHWProcessTaskQryBo> taskQryBoList = JSONObject.parseArray(JSON.toJSONString(dealReqBO.getTaskInstList()), TrainHWProcessTaskQryBo.class);
            TrainHWTaskQryBO taskQryBO = new TrainHWTaskQryBO();
            taskQryBO.setTaskList(taskQryBoList);
            trainHWProcessTaskModel.addTaskBatch(taskQryBO);
            return new TrainHWTaskDealRspBO();
        }
        //更新
        if (!CollectionUtils.isEmpty(dealReqBO.getCompletedTaskList())) {
            //更新
            List<TrainHWProcessTaskQryBo> taskQryBoList = JSONObject.parseArray(JSON.toJSONString(dealReqBO.getCompletedTaskList()), TrainHWProcessTaskQryBo.class);
            TrainHWTaskUpdateQryBO updateQryBO = new TrainHWTaskUpdateQryBO();
            updateQryBO.setTaskList(taskQryBoList);
            trainHWProcessTaskModel.updateBatchTask(updateQryBO);
            if ("true".equals(dealReqBO.getLinkJudge())) {
                //当前步骤已完成
                TrainHWProcessTaskQryBo bo = new TrainHWProcessTaskQryBo();
                bo.setStepStatus(TrainHWRspConstant.PROSECC_TASK_STATE.done);
                bo.setProcInstId(dealReqBO.getProcInstId());
                bo.setStepCode(dealReqBO.getCompletedTaskList().get(0).getStepCode());
                trainHWProcessTaskModel.updateTask(bo);
            }
        }
        if (!CollectionUtils.isEmpty(dealReqBO.getTaskInstList())) {
            //新增
            //新增流程实例表
            List<TrainHWProcessTaskQryBo> taskQryBoList = JSONObject.parseArray(JSON.toJSONString(dealReqBO.getTaskInstList()), TrainHWProcessTaskQryBo.class);
            TrainHWTaskQryBO taskQryBO = new TrainHWTaskQryBO();
            taskQryBO.setTaskList(taskQryBoList);
            trainHWProcessTaskModel.addTaskBatch(taskQryBO);
        }
        if (dealReqBO.getIsFinish() == 1) {
            //更新审批已完成
            TrainHWProcessProcInstQryBO qryBO = new TrainHWProcessProcInstQryBO();
            qryBO.setIsFinish(1);
            qryBO.setProcInstId(dealReqBO.getProcInstId());
            trainHWProcessTaskModel.updateProc(qryBO);
        }
        if (HW_ORDER_APPROVE_KEY.equals(dealReqBO.getProcKey()) && dealReqBO.getIsFinish() == 1) {
            //审批流程结束更新订单状态
            TrainHWOrderChangeQryBO changeQryBO = new TrainHWOrderChangeQryBO();
            changeQryBO.setOrderId(Long.parseLong(dealReqBO.getObjId()));
            changeQryBO.setOrderStatus(TrainHWRspConstant.ORDER_STATUS.TO_BE_CONFIRMED);
            trainHWOrderModel.updateOrderStatus(changeQryBO);
        }
        return new TrainHWTaskDealRspBO();
    }
}
