package com.tydic.train.service.task;

import com.tydic.dyc.base.utils.JUtil;
import com.tydic.train.constants.TrainHWRspConstant;
import com.tydic.train.model.workflow.TrainHWProcessTaskModel;
import com.tydic.train.model.workflow.qryBo.TrainHWProcessTaskQryBo;
import com.tydic.train.model.workflow.subBo.TrainHWProcessTaskSubBO;
import com.tydic.train.service.task.bo.TrainHWTaskQryReqBO;
import com.tydic.train.service.task.bo.TrainHWTaskQryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author Hanwei
 * @version 1.0
 * @Desc TrainHWTaskQryServiceImpl
 * @ClassName TrainHWTaskQryServiceImpl
 * @date 2023/8/31 18:18
 */
@HTServiceImpl
public class TrainHWTaskQryServiceImpl implements TrainHWTaskQryService {
    @Autowired
    private TrainHWProcessTaskModel trainHWProcessTaskModel;

    @Override
    public TrainHWTaskQryRspBO qryTask(TrainHWTaskQryReqBO reqBO) {
        TrainHWProcessTaskQryBo qryBo = new TrainHWProcessTaskQryBo();
        qryBo.setObjId(reqBO.getOrderId().toString());
        qryBo.setPendingUserId(reqBO.getUserId().toString());
        qryBo.setStepStatus(TrainHWRspConstant.PROSECC_TASK_STATE.wait);
        TrainHWProcessTaskSubBO qryTask = trainHWProcessTaskModel.qryTask(qryBo);
        return JUtil.js(qryTask,TrainHWTaskQryRspBO.class);
    }
}
