package com.tydic.train.service.task;

import com.tydic.dyc.base.utils.JUtil;
import com.tydic.train.constants.TrainLHLConstant;
import com.tydic.train.constants.TrainLHLOrderStatusEnum;
import com.tydic.train.model.order.TrainLHLOrderDO;
import com.tydic.train.model.order.TrainLHLOrderItemDO;
import com.tydic.train.model.order.TrainLHLOrderModel;
import com.tydic.train.model.shiporder.TrainLHLShipOrderDO;
import com.tydic.train.model.shiporder.TrainLHLShipOrderItemDO;
import com.tydic.train.model.shiporder.TrainLHLShipOrderModel;
import com.tydic.train.model.task.TrainLHLProcessInstDO;
import com.tydic.train.model.task.TrainLHLTaskInstDO;
import com.tydic.train.model.task.TrainLHLTaskModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.course.exception.BaseBusinessException;
import com.tydic.train.service.task.bo.TrainLHLTaskBO;
import com.tydic.train.service.task.bo.TrainLHLTaskDealReqBO;
import com.tydic.train.service.task.bo.TrainLHLTaskDealRspBO;
import com.tydic.train.utils.OrderGenerateIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


@HTServiceImpl
public class TrainLHLTaskDealServiceImpl implements TrainLHLTaskDealService {

    @Autowired
    private TrainLHLTaskModel trainLHLTaskModel;
    @Autowired
    private TrainLHLOrderModel trainLHLOrderModel;
    @Autowired
    private TrainLHLShipOrderModel trainLHLShipOrderModel;

    @Autowired
    private OrderGenerateIdUtil idUtil;

    @Override
    public TrainLHLTaskDealRspBO dealTask(TrainLHLTaskDealReqBO reqBO) {
        TrainLHLTaskDealRspBO rspBO = new TrainLHLTaskDealRspBO();

        // 流程实例入库
        TrainLHLProcessInstDO temp = new TrainLHLProcessInstDO();
        temp.setProcInstId(reqBO.getProcInstId());
        List<TrainLHLProcessInstDO> processList = trainLHLTaskModel.getProcessList(temp);
        if (CollectionUtils.isEmpty(processList)) {
            trainLHLTaskModel.insertProcess(JUtil.js(reqBO, TrainLHLProcessInstDO.class));
        }

        // 任务入库
        if (!CollectionUtils.isEmpty(reqBO.getTaskInstList())) {
            for (TrainLHLTaskBO each : reqBO.getTaskInstList()) {
                TrainLHLTaskInstDO js = JUtil.js(each, TrainLHLTaskInstDO.class);
                js.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.ACTIVATION);
                trainLHLTaskModel.insert(js);
            }
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    @Override
    public TrainLHLTaskDealRspBO updateTaskAndOrder(TrainLHLTaskDealReqBO reqBO) {
        TrainLHLTaskDealRspBO rspBO = new TrainLHLTaskDealRspBO();

        // 拿到订单id
        TrainLHLProcessInstDO trainLHLTaskInstDO = new TrainLHLProcessInstDO();
        trainLHLTaskInstDO.setProcInstId(reqBO.getProcInstId());
        List<TrainLHLProcessInstDO> processList = trainLHLTaskModel.getProcessList(trainLHLTaskInstDO);
        if (CollectionUtils.isEmpty(processList)) {
            throw new BaseBusinessException("8888", "中心层流程实例不存在");
        }


        // 流程已结束
        if (reqBO.getIsFinish() == 1) {
            // 当前环节是否为
            // 订单、订单明细改状态
            TrainLHLOrderDO orderDO = new TrainLHLOrderDO();
            orderDO.setOrderId(Long.parseLong(processList.get(0).getObjId()));
            orderDO.setOrderStatus(TrainLHLOrderStatusEnum.getStatusByStepCode(reqBO.getNextStepCode()));
            // 若为拒单
            if (reqBO.getAcceptFlag() != null && reqBO.getAcceptFlag() == 1) {
                orderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_005.getOrderStatus());
                orderDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
            }
            // 若为审批驳回
            else if ("1".equals(reqBO.getApproveResult())) {
                orderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_007.getOrderStatus());
                orderDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
            } else {
                // 发货结束
                orderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_004.getOrderStatus());
                // 创建发货单
                createShipOrder(Long.parseLong(processList.get(0).getObjId()), reqBO);
            }
            trainLHLOrderModel.updateBy(orderDO);
        } else {
            // 流程未结束
            // 根据环节改订单状态
            TrainLHLOrderDO orderDO = new TrainLHLOrderDO();
            orderDO.setOrderId(Long.parseLong(processList.get(0).getObjId()));
            orderDO.setOrderStatus(TrainLHLOrderStatusEnum.getStatusByStepCode(reqBO.getNextStepCode()));
            trainLHLOrderModel.updateBy(orderDO);
        }


        // 流程是否结束，结束了就更新实例为完成，并判断是否取消
        if (reqBO.getIsFinish() == 1) {
            TrainLHLProcessInstDO trainLHLProcessInstDO = new TrainLHLProcessInstDO();
            trainLHLProcessInstDO.setProcInstId(reqBO.getProcInstId());
            trainLHLProcessInstDO.setIsFinish(reqBO.getIsFinish());
            trainLHLTaskModel.updateByProcess(trainLHLProcessInstDO);

            TrainLHLTaskInstDO taskInstDO = new TrainLHLTaskInstDO();
            taskInstDO.setProcInstId(reqBO.getProcInstId());
            taskInstDO.setStepStatus(reqBO.getIsFinish());
            trainLHLTaskModel.updateBy(taskInstDO);
        } else {
            // 流程没结束就只处理当前任务为已完成
            TrainLHLTaskInstDO taskInstDO = new TrainLHLTaskInstDO();
            taskInstDO.setTaskId(reqBO.getTaskId().toString());
            taskInstDO.setStepStatus(TrainLHLConstant.PROSECC_TASK_STATE.done);
            trainLHLTaskModel.updateBy(taskInstDO);
        }


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    @Override
    public TrainLHLTaskDealRspBO stopTask(List<String> procInstIds) {
        TrainLHLTaskDealRspBO rspBO = new TrainLHLTaskDealRspBO();

        if (CollectionUtils.isEmpty(procInstIds)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return rspBO;
        }

        // 拿到订单id
        TrainLHLProcessInstDO trainLHLTaskInstDO = new TrainLHLProcessInstDO();
        trainLHLTaskInstDO.setProcInstIds(procInstIds);
        List<TrainLHLProcessInstDO> processList = trainLHLTaskModel.getProcessList(trainLHLTaskInstDO);
        if (CollectionUtils.isEmpty(processList)) {
            throw new BaseBusinessException("8888", "中心层流程实例不存在");
        }

        // 订单、订单明细改为删除
        TrainLHLOrderDO trainLHLOrderDO = new TrainLHLOrderDO();
        trainLHLOrderDO.setOrderIds(processList.stream().map(e -> Long.parseLong(e.getObjId())).collect(Collectors.toList()));
        trainLHLOrderDO.setOrderStatus(TrainLHLOrderStatusEnum.O_006.getOrderStatus());
        trainLHLOrderDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
        trainLHLOrderModel.updateBy(trainLHLOrderDO);

        // 改任务为删除
        TrainLHLProcessInstDO trainLHLProcessInstDO = new TrainLHLProcessInstDO();
        trainLHLProcessInstDO.setProcInstIds(procInstIds);
        trainLHLProcessInstDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
        trainLHLTaskModel.updateByProcess(trainLHLProcessInstDO);

        TrainLHLTaskInstDO taskInstDO = new TrainLHLTaskInstDO();
        taskInstDO.setProcInstIds(procInstIds);
        taskInstDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.DEL);
        trainLHLTaskModel.updateBy(taskInstDO);


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 创建发货单
     */
    private void createShipOrder(Long orderId, TrainLHLTaskDealReqBO reqBO) {

        TrainLHLOrderDO trainLHLOrderDO = trainLHLOrderModel.qryOrder(orderId);

        TrainLHLShipOrderDO inserDO = new TrainLHLShipOrderDO();
        BeanUtils.copyProperties(trainLHLOrderDO, inserDO);
        inserDO.setShipOrderId(idUtil.nextId());
        inserDO.setShipOrderNo("lhl-HFD-" + System.currentTimeMillis());
        inserDO.setShipUserId(reqBO.getUserId());
        inserDO.setShipUserName(reqBO.getUsername());
        inserDO.setShipTime(new Date(System.currentTimeMillis()));
        inserDO.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.ACTIVATION);

        List<TrainLHLShipOrderItemDO> itemList = new ArrayList<>();
        for (TrainLHLOrderItemDO each : trainLHLOrderDO.getOrderDetailInfo()) {
            TrainLHLShipOrderItemDO item = JUtil.js(each, TrainLHLShipOrderItemDO.class);
            item.setShipItemId(idUtil.nextId());
            item.setShipOrderId(inserDO.getShipOrderId());
            item.setOrderId(each.getOrderId());
            item.setItemId(each.getItemId());
            item.setGoodsId(each.getGoodsId());
            item.setShipCount(each.getCount());
            item.setCount(each.getCount());
            item.setDelFlag(TrainLHLConstant.ORDER_DEL_STATE.ACTIVATION);
            itemList.add(item);
        }
        inserDO.setItemList(itemList);

        trainLHLShipOrderModel.insert(inserDO);
    }


}
