package com.tydic.train.service.tfqumc.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.train.model.tfqumc.TrainTfqUserModel;
import com.tydic.train.model.tfqumc.qrybo.TrainTfqUserQryBO;
import com.tydic.train.model.tfqumc.sub.TrainTfqUserDO;
import com.tydic.train.service.tfqumc.api.TrainTfqQueryUserService;
import com.tydic.train.service.tfqumc.bo.TrainTfqQueryUserReqBO;
import com.tydic.train.service.tfqumc.bo.TrainTfqQueryUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;

/**
 * 标题 TrainTfqQueryUserServiceImpl
 * 说明 用户查询
 * 时间 2023/8/28 18:25
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqQueryUserServiceImpl implements TrainTfqQueryUserService {

    @Resource
    private TrainTfqUserModel trainTfqUserModel;

    /**
     * 用户查询
     * @param reqBO
     * @return
     */
    @Override
    public TrainTfqQueryUserRspBO queryUser(TrainTfqQueryUserReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        TrainTfqUserQryBO trainTfqUserQryBO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),TrainTfqUserQryBO.class);
        TrainTfqUserDO model = trainTfqUserModel.getModel(trainTfqUserQryBO);
        if(model == null){
            throw new ZTBusinessException("未查询到用户");
        }
        TrainTfqQueryUserRspBO rspBO = JSONObject.parseObject(JSONObject.toJSONString(model),TrainTfqQueryUserRspBO.class);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(TrainTfqQueryUserReqBO reqBO){
        if (reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getUserId() == null){
            throw new ZTBusinessException("入参用户id不能为null");
        }
    }
}
