package com.tydic.train.service.tfquoc;

import com.alibaba.nacos.client.utils.StringUtils;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqProcessInstDO;
import com.tydic.train.service.tfquoc.api.TrainTfqAddProcessInstService;
import com.tydic.train.service.tfquoc.bo.TrainTfqAddProcessInstReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqAddProcessInstRspBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

/**
 * 标题 TrainTfqAddProcessInstServiceImpl
 * 说明
 * 时间 2023/8/30 17:29
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqAddProcessInstServiceImpl implements TrainTfqAddProcessInstService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @Override
    public TrainTfqAddProcessInstRspBO addProcessInst(TrainTfqAddProcessInstReqBO reqBO) {
        List<TrainTfqProcessInstDO> trainTfqProcessInstDOS = TrainTfqRuUtil.jsl(reqBO.getList(), TrainTfqProcessInstDO.class);
        for (TrainTfqProcessInstDO processInst : trainTfqProcessInstDOS) {
            TrainTfqProcessInstDO trainTfqProcessInstDO = new TrainTfqProcessInstDO();
            trainTfqProcessInstDO.setProcInstId(processInst.getProcInstId());
            TrainTfqProcessInstDO checke = trainTfqOrderModel.getProcessInst(trainTfqProcessInstDO);
            if (checke != null) {
                trainTfqProcessInstDOS.remove(processInst);
                continue;
            }
            if (!StringUtils.isBlank(processInst.getParentProcInstId()) && StringUtils.isBlank(processInst.getObjId())) {
                TrainTfqProcessInstDO processInstDO = new TrainTfqProcessInstDO();
                processInstDO.setProcInstId(processInst.getParentProcInstId());
                TrainTfqProcessInstDO father = trainTfqOrderModel.getProcessInst(processInstDO);
                processInst.setObjId(father.getObjId());
            }
            processInst.setDelFlag(0);
            processInst.setIsFinish(0);
            processInst.setObjType(1);
        }
        trainTfqOrderModel.insertBatchProcessIns(trainTfqProcessInstDOS);
        return TrainTfqRuUtil.success(TrainTfqAddProcessInstRspBO.class);
    }
}
