package com.tydic.train.service.tfquoc;

import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqTaskInstDO;
import com.tydic.train.service.tfquoc.api.TrainTfqAddTaskInstService;
import com.tydic.train.service.tfquoc.bo.TrainTfqAddTaskInstReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqAddTaskInstRspBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;
import java.util.List;

/**
 * 标题 TrainTfqAddTaskInstServiceImpl
 * 说明
 * 时间 2023/8/30 17:35
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqAddTaskInstServiceImpl implements TrainTfqAddTaskInstService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @Override
    public TrainTfqAddTaskInstRspBO addTaskInst(TrainTfqAddTaskInstReqBO reqBO) {

        List<TrainTfqTaskInstDO> trainTfqTaskInstDOS = TrainTfqRuUtil.jsl(reqBO.getList(),TrainTfqTaskInstDO.class);

        for (TrainTfqTaskInstDO taskInstDO :trainTfqTaskInstDOS) {
            taskInstDO.setStepStatus(0);
            taskInstDO.setDelFlag(0);
        }
        trainTfqOrderModel.insertBatchTaskInst(trainTfqTaskInstDOS);
        return TrainTfqRuUtil.success(TrainTfqAddTaskInstRspBO.class);
    }
}
