package com.tydic.train.service.tfquoc;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqCreateOrderDO;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.tfquoc.api.TrainTfqCreateOrderService;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateOrderReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateOrderRspBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqGoodsInfoBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * 标题 TrainTfqCreateOrderServiceImpl
 * 说明 订单创建
 * 时间 2023/8/28 16:57
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqCreateOrderServiceImpl implements TrainTfqCreateOrderService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    /**
     * 订单创建
     * @param reqBO
     * @return
     */
    @Override
    public TrainTfqCreateOrderRspBO createOrder(TrainTfqCreateOrderReqBO reqBO) {
        TrainTfqCreateOrderDO trainTfqCreateOrderDO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), TrainTfqCreateOrderDO.class);
        TrainTfqCreateOrderDO order = trainTfqOrderModel.createOrder(trainTfqCreateOrderDO);
        TrainTfqCreateOrderRspBO rspBO =  new TrainTfqCreateOrderRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setOrderId(order.getOrderId());
        rspBO.setOrderNo(order.getOrderNo());
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(TrainTfqCreateOrderReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getCreateUserId() == null){
            throw new ZTBusinessException("入参【创建人id】不能为null");
        }
        if(StringUtils.isBlank(reqBO.getCreateUserName())){
            throw new ZTBusinessException("入参【创建人名称】不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getGoodsInfoList())){
            throw new ZTBusinessException("入参商品信息集合不能为null");
        }

        for (TrainTfqGoodsInfoBO item: reqBO.getGoodsInfoList()) {
            if(item.getGoodsId() == null){
                throw new ZTBusinessException("入参订单明细【商品id】不能为null");
            }
            if(item.getGoodsPrice() == null){
                throw new ZTBusinessException("入参订单明细【商品价格】不能为null");
            }
            if(item.getGoodsPrice().compareTo(BigDecimal.ZERO) <= 0){
                throw new ZTBusinessException("入参订单明细【商品价格】必须为正数");
            }
            if(item.getCount() == null){
                throw new ZTBusinessException("入参订单明细【购买数量】不能为null");
            }
            if(item.getCount() <= 0){
                throw new ZTBusinessException("入参订单明细【购买数量】必须为正数");
            }
        }
    }
}
