package com.tydic.train.service.tfquoc;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqCreateShipOrderDO;
import com.tydic.train.service.tfquoc.api.TrainTfqCreateShipOrderService;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateShipOrderReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqCreateShipOrderRspBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqShipOrderItemBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;

/**
 * 标题 TrainTfqCreateShipOrderServiceImpl
 * 说明 发货
 * 时间 2023/8/29 18:35
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqCreateShipOrderServiceImpl implements TrainTfqCreateShipOrderService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    /**
     * 发货
     * @param reqBO
     * @return
     */
    @Override
    public TrainTfqCreateShipOrderRspBO createShipOrder(TrainTfqCreateShipOrderReqBO reqBO) {
        verifyParam(reqBO);
        TrainTfqCreateShipOrderDO trainTfqCreateShipOrderDO = TrainTfqRuUtil.js(reqBO,TrainTfqCreateShipOrderDO.class);
        trainTfqOrderModel.createShipOrder(trainTfqCreateShipOrderDO);
        return TrainTfqRuUtil.success(TrainTfqCreateShipOrderRspBO.class);
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(TrainTfqCreateShipOrderReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getShipOrderItemList())){
            throw new ZTBusinessException("入参发货明细不能为null");
        }
        for (TrainTfqShipOrderItemBO itemBO :reqBO.getShipOrderItemList()) {
            if(itemBO.getShipCount() == null){
                throw new ZTBusinessException("入参发货数量不能为null");
            }
            if(itemBO.getShipCount() <= 0){
                throw new ZTBusinessException("入参发货数量必须为正数");
            }
            if(itemBO.getItemId() == null){
                throw new ZTBusinessException("入参订单明细id不能为null");
            }
        }
    }
}
