package com.tydic.train.service.tfquoc;

import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.qrybo.TrainTfqTaskInstQryBO;
import com.tydic.train.model.tfquoc.sub.TrainTfqProcessInstDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqTaskInstDO;
import com.tydic.train.service.tfquoc.api.TrainTfqDealFlowService;
import com.tydic.train.service.tfquoc.bo.TrainTfqDealFlowReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqDealFlowRspBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqTaskInstBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题 TrainTfqDealFlowServiceImpl
 * 说明
 * 时间 2023/8/31 17:59
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqDealFlowServiceImpl implements TrainTfqDealFlowService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @Override
    public TrainTfqDealFlowRspBO dealFlow(TrainTfqDealFlowReqBO reqBO) {
        if(reqBO.getIsfinish() == 1){
            updateProcessInst(reqBO);
            TrainTfqTaskInstQryBO trainTfqTaskInstQryBO = new TrainTfqTaskInstQryBO();
            trainTfqTaskInstQryBO.setProcInstId(reqBO.getProcInstId());
            trainTfqTaskInstQryBO.setStepStatus(reqBO.getIsfinish());
            trainTfqTaskInstQryBO.setQryStepStatus(0);
            trainTfqTaskInstQryBO.setDealTime(new Date());
            trainTfqOrderModel.updateBatchByTaskId(trainTfqTaskInstQryBO);
        }else {
            TrainTfqProcessInstDO trainTfqProcessInstDO = new TrainTfqProcessInstDO();
            trainTfqProcessInstDO.setProcInstId(reqBO.getProcInstId());
            TrainTfqProcessInstDO processInst = trainTfqOrderModel.getProcessInst(trainTfqProcessInstDO);
            if(processInst == null){
                addProcessInst(reqBO);
            }else {
                updateProcessInst(reqBO);
//                addProcessInst(reqBO);
                if(reqBO.getLinkJudge()){
                    TrainTfqTaskInstQryBO trainTfqTaskInstQryBO = new TrainTfqTaskInstQryBO();
                    trainTfqTaskInstQryBO.setProcInstId(reqBO.getProcInstId());
                    trainTfqTaskInstQryBO.setStepStatus(1);
                    trainTfqTaskInstQryBO.setQryStepStatus(0);
                    trainTfqTaskInstQryBO.setDealTime(new Date());
                    trainTfqOrderModel.updateBatchByTaskId(trainTfqTaskInstQryBO);
                }else {
                    if(!CollectionUtils.isEmpty(reqBO.getOverList())){
                        List<String> list = reqBO.getOverList().stream().map(TrainTfqTaskInstBO::getTaskId).collect(Collectors.toList());
                        TrainTfqTaskInstQryBO trainTfqTaskInstQryBO = new TrainTfqTaskInstQryBO();
                        trainTfqTaskInstQryBO.setTaskIdList(list);
                        trainTfqTaskInstQryBO.setDealTime(new Date());
                        trainTfqTaskInstQryBO.setStepStatus(1);
                        trainTfqOrderModel.updateBatchByTaskId(trainTfqTaskInstQryBO);
                    }
                }
            }
        }
        addTask(reqBO);
        return TrainTfqRuUtil.success(TrainTfqDealFlowRspBO.class);
    }

    private void addTask(TrainTfqDealFlowReqBO reqBO){
        if(!CollectionUtils.isEmpty(reqBO.getTaskList())){
            List<TrainTfqTaskInstDO> trainTfqTaskInstDOS = TrainTfqRuUtil.jsl(reqBO.getTaskList(),TrainTfqTaskInstDO.class);
            trainTfqTaskInstDOS.stream().forEach(taskInstDO -> {
                taskInstDO.setStepStatus(0);
                taskInstDO.setDelFlag(0);
            });
            trainTfqOrderModel.insertBatchTaskInst(trainTfqTaskInstDOS);
        }
    }

    private void updateProcessInst(TrainTfqDealFlowReqBO reqBO){
        TrainTfqProcessInstDO trainTfqProcessInstDO = new TrainTfqProcessInstDO();
        trainTfqProcessInstDO.setProcInstId(reqBO.getProcInstId());
        trainTfqProcessInstDO.setIsFinish(reqBO.getIsfinish());
        trainTfqProcessInstDO.setProcDefId(reqBO.getProcDefId());
        trainTfqProcessInstDO.setStepCode(reqBO.getStepCode());
        trainTfqProcessInstDO.setStepName(reqBO.getStepName());
        trainTfqOrderModel.updateBatchProcessIns(Collections.singletonList(trainTfqProcessInstDO));
    }

    private void addProcessInst(TrainTfqDealFlowReqBO reqBO){
        TrainTfqProcessInstDO addProcessInst = new TrainTfqProcessInstDO();
        addProcessInst.setProcInstId(reqBO.getProcInstId());
        addProcessInst.setProcKey(reqBO.getProcDefKey());
        addProcessInst.setParentProcInstId(reqBO.getParentProcInstId());
        addProcessInst.setProcDefId(reqBO.getProcDefId());
        addProcessInst.setIsFinish(0);
        addProcessInst.setObjId(reqBO.getOrderId().toString());
        addProcessInst.setObjType(1);
        addProcessInst.setStepCode(reqBO.getStepCode());
        addProcessInst.setStepName(reqBO.getStepName());
        addProcessInst.setDelFlag(0);
        trainTfqOrderModel.insertBatchProcessIns(Collections.singletonList(addProcessInst));
    }
}
