package com.tydic.train.service.tfquoc;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.train.model.tfquoc.sub.TrainTfqOrderDetailsDO;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.qrybo.TrainTfqOrderQryBO;
import com.tydic.train.service.tfquoc.api.TrainTfqOrderDetailsService;
import com.tydic.train.service.tfquoc.bo.TrainTfqOrderDetailsReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqOrderDetailsRspBO;
import com.tydic.train.service.tfquoc.constants.TrainTfqOrderConstants;
import com.tydic.train.service.tfquoc.constants.TrainTfqOrderStatusEnum;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;

/**
 * 标题 TrainTfqOrderDetailsServiceImpl
 * 说明 订单详情查询实现
 * 时间 2023/8/28 16:40
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqOrderDetailsServiceImpl implements TrainTfqOrderDetailsService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    /**
     * 订单详情查询实现
     * @param reqBO
     * @return
     */
    @Override
    public TrainTfqOrderDetailsRspBO orderDetails(TrainTfqOrderDetailsReqBO reqBO) {
        verifyParam(reqBO);
        TrainTfqOrderQryBO trainTfqOrderQryBO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),TrainTfqOrderQryBO.class);
        trainTfqOrderQryBO.setDealFlag(TrainTfqOrderConstants.DelFlag.NO);
        TrainTfqOrderDetailsDO orderDetails = trainTfqOrderModel.getOrderDetails(trainTfqOrderQryBO);
        TrainTfqOrderDetailsRspBO rspBO =   JSONObject.parseObject(JSONObject.toJSONString(orderDetails),TrainTfqOrderDetailsRspBO.class);
        rspBO.getOrder().setOrderStatusStr(TrainTfqOrderStatusEnum.getStatusStr(rspBO.getOrder().getOrderStatus()));
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }


    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(TrainTfqOrderDetailsReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getOrderId() == null){
            throw new ZTBusinessException("入参订单id不能为null");
        }
    }
}
