package com.tydic.train.service.tfquoc;

import com.alibaba.nacos.client.utils.StringUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqProcessInstDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqTaskInstDO;
import com.tydic.train.service.tfquoc.api.TrainTfqQueryTaskIdListService;
import com.tydic.train.service.tfquoc.bo.TrainTfqQueryTaskIdListReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqQueryTaskIdListRspBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题 TrainTfqQueryTaskIdListServiceImpl
 * 说明
 * 时间 2023/8/30 17:53
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqQueryTaskIdListServiceImpl implements TrainTfqQueryTaskIdListService {
    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @Override
    public TrainTfqQueryTaskIdListRspBO queryTaskIdList(TrainTfqQueryTaskIdListReqBO reqBO) {
        TrainTfqProcessInstDO trainTfqProcessInstDO = new TrainTfqProcessInstDO();
        trainTfqProcessInstDO.setObjType(reqBO.getObjType());
        trainTfqProcessInstDO.setObjId(reqBO.getObjId().toString());
        trainTfqProcessInstDO.setIsFinish(0);
        trainTfqProcessInstDO.setDelFlag(0);
        trainTfqProcessInstDO.setProcKey(reqBO.getProcKey());
        TrainTfqProcessInstDO processInst = trainTfqOrderModel.getProcessInst(trainTfqProcessInstDO);
        if(processInst == null){
            throw new ZTBusinessException("未查询到流程实例");
        }

        TrainTfqTaskInstDO trainTfqTaskInstDO = new TrainTfqTaskInstDO();
        trainTfqTaskInstDO.setProcInstId(processInst.getProcInstId());
        trainTfqTaskInstDO.setStepStatus(0);
        trainTfqTaskInstDO.setDelFlag(0);
        if(reqBO.getUserId() != null){
            trainTfqTaskInstDO.setPendingUserId(String.valueOf(reqBO.getUserId()));
        }
        List<TrainTfqTaskInstDO> taskList = trainTfqOrderModel.getTaskList(trainTfqTaskInstDO);
        if(CollectionUtils.isEmpty(taskList)){
            throw new ZTBusinessException("未查询到任务实例");
        }
        TrainTfqQueryTaskIdListRspBO rspBO = TrainTfqRuUtil.success(TrainTfqQueryTaskIdListRspBO.class);
        rspBO.setTaskIdList(taskList.stream().map(TrainTfqTaskInstDO::getTaskId).collect(Collectors.toList()));
        return rspBO;
    }
}
