package com.tydic.train.service.tfquoc;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqCreateOrderDO;
import com.tydic.train.model.tfquoc.sub.TrainTfqOrderDO;
import com.tydic.train.service.tfquoc.api.TrainTfqUpdateOrderService;
import com.tydic.train.service.tfquoc.bo.TrainTfqUpdateOrderReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqUpdateOrderRspBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;

/**
 * 标题 TrainTfqUpdateOrderServiceImpl
 * 说明 更新订单
 * 时间 2023/8/29 17:29
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqUpdateOrderServiceImpl implements TrainTfqUpdateOrderService {
    
    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;
    
    @Override
    public TrainTfqUpdateOrderRspBO updateOrder(TrainTfqUpdateOrderReqBO reqBO) {
        TrainTfqOrderDO orderDO = TrainTfqRuUtil.js(reqBO, TrainTfqOrderDO.class);
        trainTfqOrderModel.update(orderDO);
        return TrainTfqRuUtil.success(TrainTfqUpdateOrderRspBO.class);
    }
    
    private void verifyParam(TrainTfqUpdateOrderReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getOrderId() == null){
            throw new ZTBusinessException("入参订单id不能为null");
        }
    }
}
