package com.tydic.train.service.tfquoc;

import com.alibaba.fastjson.JSONObject;
import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.sub.TrainTfqProcessInstDO;
import com.tydic.train.service.tfquoc.api.TrainTfqUpdateProcessInstService;
import com.tydic.train.service.tfquoc.bo.TrainTfqUpdateProcessInstReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqUpdateProcessInstRspBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;
import java.util.List;

/**
 * 标题 TrainTfqUpdateProcessInstServiceImpl
 * 说明
 * 时间 2023/8/30 17:42
 *
 * @author 唐富强
 */
@HTServiceImpl
@Slf4j
public class TrainTfqUpdateProcessInstServiceImpl implements TrainTfqUpdateProcessInstService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @Override
    public TrainTfqUpdateProcessInstRspBO updateProcessInst(TrainTfqUpdateProcessInstReqBO reqBO) {
        List<TrainTfqProcessInstDO> trainTfqProcessInstDOS = TrainTfqRuUtil.jsl(reqBO.getList(),TrainTfqProcessInstDO.class);
        log.info("更新流程实例入参{}", JSONObject.toJSONString(trainTfqProcessInstDOS));
        trainTfqOrderModel.updateBatchProcessIns(trainTfqProcessInstDOS);
        return TrainTfqRuUtil.success(TrainTfqUpdateProcessInstRspBO.class);
    }
}
