package com.tydic.train.service.tfquoc;

import com.tydic.train.model.tfquoc.TrainTfqOrderModel;
import com.tydic.train.model.tfquoc.qrybo.TrainTfqTaskInstQryBO;
import com.tydic.train.service.tfquoc.api.TrainTfqUpdateTaskInstService;
import com.tydic.train.service.tfquoc.bo.TrainTfqUpdateTaskInstReqBO;
import com.tydic.train.service.tfquoc.bo.TrainTfqUpdateTaskInstRspBO;
import com.tydic.train.utils.TrainTfqRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 标题 TrainTfqUpdateTaskInstServiceReqBO
 * 说明
 * 时间 2023/8/30 17:48
 *
 * @author 唐富强
 */
@HTServiceImpl
public class TrainTfqUpdateTaskInstServiceImpl implements TrainTfqUpdateTaskInstService {

    @Resource
    private TrainTfqOrderModel trainTfqOrderModel;

    @Override
    public TrainTfqUpdateTaskInstRspBO update(TrainTfqUpdateTaskInstReqBO reqBO) {
        TrainTfqTaskInstQryBO trainTfqTaskInstQryBO = TrainTfqRuUtil.js(reqBO,TrainTfqTaskInstQryBO.class);
        trainTfqTaskInstQryBO.setDealTime(new Date());
        trainTfqOrderModel.updateBatchByTaskId(trainTfqTaskInstQryBO);
        return TrainTfqRuUtil.success(TrainTfqUpdateTaskInstRspBO.class);
    }
}
