package com.tydic.train.service.user;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.user.TrainLYUserRepBO;
import com.tydic.train.model.user.TrainLYUserRspBO;
import com.tydic.train.model.user.impl.TrainLYUserModelImpl;
import com.tydic.train.service.user.bo.TrainLYUserQryServiceReqBO;
import com.tydic.train.service.user.bo.TrainLYUserQryServiceRspBO;
import com.tydic.train.service.user.bo.TrainZyyQryUserInfoReqBO;
import jdk.nashorn.internal.scripts.JS;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

/**
 * 标题：TrainLYQryUserInfoServiceImpl
 * 说明：
 * 时间： 2023-08-29 18:05
 * 作者 @author LY
 */
@HTServiceImpl
public class TrainLYQryUserInfoServiceImpl implements TrainLYQryUserInfoService{
    private TrainLYUserModelImpl trainLYUserModel;

    public TrainLYQryUserInfoServiceImpl(TrainLYUserModelImpl trainLYUserModel) {
        this.trainLYUserModel = trainLYUserModel;
    }

    @Override
    public TrainLYUserQryServiceRspBO qryUserInfo(TrainLYUserQryServiceReqBO reqBO) {
        checkReq(reqBO);
        TrainLYUserRepBO trainLYUserRepBO = new TrainLYUserRepBO();
        BeanUtils.copyProperties(reqBO,trainLYUserRepBO);
        TrainLYUserRspBO trainLYUserRspBO = trainLYUserModel.qryUserInfoSingle(trainLYUserRepBO);
        return JSON.parseObject(JSON.toJSONString(trainLYUserRspBO),TrainLYUserQryServiceRspBO.class);
    }


    private void checkReq(TrainLYUserQryServiceReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("入参用户id不能为空");
        }
    }
}
