package com.tydic.train.service.user;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.user.TrainYyfUserDO;
import com.tydic.train.model.user.TrainYyfUserModel;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.user.bo.TrainYyfQryUserInfoReqBO;
import com.tydic.train.service.user.bo.TrainYyfQryUserInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HTServiceImpl
public class TrainYyfQryUserInfoServiceImpl implements TrainYyfQryUserInfoService {
    @Autowired
    private TrainYyfUserModel trainYyfUserModel;

    @Override
    public TrainYyfQryUserInfoRspBO qryUserInfo(TrainYyfQryUserInfoReqBO reqBO) {
        checkReq(reqBO);
        TrainYyfQryUserInfoRspBO rspBo = new TrainYyfQryUserInfoRspBO();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        TrainYyfUserDO trainYyfUserQryBo = new TrainYyfUserDO();
        BeanUtils.copyProperties(reqBO, trainYyfUserQryBo);
        TrainYyfUserDO trainYyfUserDo = trainYyfUserModel.qryUserDetail(trainYyfUserQryBo);
        rspBo = JSONObject.parseObject(JSONObject.toJSONString(trainYyfUserDo), TrainYyfQryUserInfoRspBO.class);

        return rspBo;
    }
    /**
     * 入参校验
     */
    private void checkReq(TrainYyfQryUserInfoReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("入参用户id不能为空");
        }
    }
}
