package com.tydic.train.service.user;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.user.TrainZyyUserDo;
import com.tydic.train.model.user.TrainZyyUserModel;
import com.tydic.train.model.user.qrybo.TrainZyyUserQryBo;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.user.bo.TrainZyyQryUserInfoReqBO;
import com.tydic.train.service.user.bo.TrainZyyQryUserInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：TrainZyyQryUserInfoServiceImpl
 * 说明：周钰焱用户信息查询领域服务实现
 * 时间：2023/8/28 16:54
 *
 * @author 周钰焱
 */
@HTServiceImpl
public class TrainZyyQryUserInfoServiceImpl implements TrainZyyQryUserInfoService {
    @Autowired
    private TrainZyyUserModel trainZyyUserModel;

    @Override
    public TrainZyyQryUserInfoRspBO qryUserInfo(TrainZyyQryUserInfoReqBO reqBO) {
        checkReq(reqBO);
        TrainZyyQryUserInfoRspBO rspBo = new TrainZyyQryUserInfoRspBO();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        TrainZyyUserQryBo trainZyyUserQryBo = new TrainZyyUserQryBo();
        BeanUtils.copyProperties(reqBO, trainZyyUserQryBo);
        TrainZyyUserDo trainZyyUserDo = trainZyyUserModel.qryUserInfoSingle(trainZyyUserQryBo);
        rspBo = JSONObject.parseObject(JSONObject.toJSONString(trainZyyUserDo), TrainZyyQryUserInfoRspBO.class);

        return rspBo;
    }
    /**
     * 入参校验
     */
    private void checkReq(TrainZyyQryUserInfoReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("入参不能为空");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("入参用户id不能为空");
        }
    }
}
