package com.tydic.train.service.zl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.train.model.zl.*;
import com.tydic.train.service.course.constants.BaseRspConstant;
import com.tydic.train.service.zl.bo.TrainZLCreateOrderReqBO;
import com.tydic.train.service.zl.bo.TrainZLCreateOrderRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

@HTServiceImpl
//@Service("trainZLCreateOrderService")
public class TrainZLCreateOrderServiceImpl implements TrainZLCreateOrderService {

    @Autowired
    private TrainZLUserModel trainZLUserModel;

    @Autowired
    private TrainZLGoodsModel trainZLGoodsModel;

    @Autowired
    private TrainZLOrderModel trainZLOrderModel;

    private static final Integer not_del = 0;

    @Override
    public TrainZLCreateOrderRspBO createOrder(TrainZLCreateOrderReqBO reqBO) {
        // 参数校验
        this.paramVf(reqBO);

        TrainZLCreateOrderRspBO rspBO = new TrainZLCreateOrderRspBO();

        // 校验用户是否存在
        TrainZLUserDO userDO = new TrainZLUserDO();
        userDO.setUserId(reqBO.getUserId());
        TrainZLUserDO userDetail = trainZLUserModel.qryUserDetail(userDO);
        if (ObjectUtil.isEmpty(userDetail)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("用户不存在");
            return rspBO;
        }

        // 校验商品是否存在
        TrainZLGoodsDO goodsDO = new TrainZLGoodsDO();
        goodsDO.setGoodsId(reqBO.getGoodsId());
        TrainZLGoodsDO goodsDetail = trainZLGoodsModel.qryGoodsDetail(goodsDO);
        if (ObjectUtil.isEmpty(goodsDetail)) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc("商品不存在");
            return rspBO;
        }

        // 新增订单
        TrainZLOrderDO insertOrderDO = new TrainZLOrderDO();
        insertOrderDO.setOrderName("订单名称");
        insertOrderDO.setOrderMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderDO.setCreateUserId(userDetail.getUserId());
        insertOrderDO.setCreateUserName(userDetail.getUserName());
        insertOrderDO.setCreateTime(new Date());
        insertOrderDO.setDelFlag(not_del);
        Long orderId = trainZLOrderModel.insertOrder(insertOrderDO);

        // 新增订单详情
        TrainZLOrderItemDO insertOrderItemDO = new TrainZLOrderItemDO();
        insertOrderItemDO.setOrderId(orderId);
        insertOrderItemDO.setGoodsId(goodsDetail.getGoodsId());
        insertOrderItemDO.setGoodsPrice(goodsDetail.getGoodsPrice());
        insertOrderItemDO.setCount(reqBO.getCount());
        insertOrderItemDO.setTotalMoney(goodsDetail.getGoodsPrice().multiply(new BigDecimal(reqBO.getCount())));
        insertOrderItemDO.setDelFlag(not_del);
        trainZLOrderModel.insertOrderItem(insertOrderItemDO);

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBO.setOrderId(orderId);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void paramVf(TrainZLCreateOrderReqBO reqBO) {
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("下单入参用户ID为空");
        }
        if (reqBO.getGoodsId() == null) {
            throw new ZTBusinessException("下单入参商品ID为空");
        }
        if (reqBO.getCount() == null) {
            throw new ZTBusinessException("下单入参购买数量为空");
        }
    }
}
