package com.tydic.train.service.zl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.train.model.zl.*;
import com.tydic.train.service.zl.bo.*;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@HTServiceImpl
//@Service("trainZLQueryOrderService")
public class TrainZLQueryOrderServiceImpl implements TrainZLQueryOrderService {

    @Autowired
    private TrainZLUserModel trainZLUserModel;

    @Autowired
    private TrainZLOrderModel trainZLOrderModel;

    @Autowired
    private TrainZLGoodsModel trainZLGoodsModel;

    @Override
    public TrainZLQueryOrderRspBO queryOrder(TrainZLQueryOrderReqBO reqBO) {
        TrainZLQueryOrderRspBO rspBO = new TrainZLQueryOrderRspBO();
        TrainZLOrderDO qryDO = new TrainZLOrderDO();
        qryDO.setOrderId(reqBO.getOrderId());
        // 查询订单信息
        TrainZLOrderDO detailDO = trainZLOrderModel.qryOrderDetail(qryDO);
        rspBO = JSONObject.parseObject(JSON.toJSONString(detailDO),TrainZLQueryOrderRspBO.class);
        rspBO.setOrderItemInfo(JSONObject.parseObject(JSON.toJSONString(detailDO.getItemDO()), TrainZLOrderItemBO.class));
        // 查询商品信息
        TrainZLGoodsDO qryGoodsDO = new TrainZLGoodsDO();
        qryGoodsDO.setGoodsId(detailDO.getItemDO().getGoodsId());
        TrainZLGoodsDO goodsDO = trainZLGoodsModel.qryGoodsDetail(qryGoodsDO);
        if (ObjectUtil.isNotEmpty(goodsDO)) {
            rspBO.setGoodsInfo(JSONObject.parseObject(JSON.toJSONString(goodsDO), TrainZLGoodsBO.class));
        }

        // 查询用户信息
        TrainZLUserDO qryUserDO = new TrainZLUserDO();
        qryUserDO.setUserId(detailDO.getCreateUserId());
        TrainZLUserDO userDO = trainZLUserModel.qryUserDetail(qryUserDO);
        if (ObjectUtil.isNotEmpty(userDO)) {
            rspBO.setUserInfo(JSONObject.parseObject(JSON.toJSONString(userDO), TrainZLUserBO.class));
        }

        return rspBO;
    }
}
