package com.tydic.train.service.zl;

import com.tydic.train.model.zl.TrainZLShipOrderItemModel;
import com.tydic.train.repository.zl.TrainZLShipOrderItemRepository;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemListRspBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemReqBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderItemRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 描述：任务实例表
 *
 * @author: zhoulu
 * @date: 2023-08-30 16:24:45
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class TrainZLShipOrderItemServiceImpl implements TrainZLShipOrderItemService {
    @Autowired
    private TrainZLShipOrderItemModel trainZLShipOrderItemRepository;

    @Override
    public TrainZLShipOrderItemRspBO queryTrainZLShipOrderItemSingle(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.queryTrainZLShipOrderItemSingle(trainShipOrderItemReqBO);
    }

    @Override
    public TrainZLShipOrderItemListRspBO queryTrainZLShipOrderItemList(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.queryTrainZLShipOrderItemList(trainShipOrderItemReqBO);
    }

    @Override
    public TrainZLShipOrderItemRspBO addTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.addTrainZLShipOrderItem(trainShipOrderItemReqBO);
    }

    @Override
    public TrainZLShipOrderItemListRspBO addListTrainZLShipOrderItem(List<TrainZLShipOrderItemReqBO> trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.addListTrainZLShipOrderItem(trainShipOrderItemReqBO);
    }

    @Override
    public TrainZLShipOrderItemRspBO updateTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.updateTrainZLShipOrderItem(trainShipOrderItemReqBO);
    }

    @Override
    public TrainZLShipOrderItemRspBO saveTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.saveTrainZLShipOrderItem(trainShipOrderItemReqBO);
    }

    @Override
    public TrainZLShipOrderItemRspBO deleteTrainZLShipOrderItem(TrainZLShipOrderItemReqBO trainShipOrderItemReqBO) {
        return trainZLShipOrderItemRepository.deleteTrainZLShipOrderItem(trainShipOrderItemReqBO);
    }
}

