package com.tydic.train.service.zl;

import com.tydic.train.model.zl.TrainZLShipOrderModel;
import com.tydic.train.repository.zl.TrainZLShipOrderRepository;
import com.tydic.train.service.zl.bo.TrainZLShipOrderListRspBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderReqBO;
import com.tydic.train.service.zl.bo.TrainZLShipOrderRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 描述：任务实例表
 *
 * @author: zhoulu
 * @date: 2023-08-30 16:24:45
 * @Copyright:2019 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于北京天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@HTServiceImpl
public class TrainZLShipOrderServiceImpl implements TrainZLShipOrderService {
    @Autowired
    private TrainZLShipOrderModel trainZLShipOrderRepository;

    @Override
    public TrainZLShipOrderRspBO queryTrainZLShipOrderSingle(TrainZLShipOrderReqBO trainShipOrderReqBO) {
        return trainZLShipOrderRepository.queryTrainZLShipOrderSingle(trainShipOrderReqBO);
    }

    @Override
    public TrainZLShipOrderListRspBO queryTrainZLShipOrderList(TrainZLShipOrderReqBO trainShipOrderReqBO) {
        return trainZLShipOrderRepository.queryTrainZLShipOrderList(trainShipOrderReqBO);
    }

    @Override
    public TrainZLShipOrderRspBO addTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO) {
        return trainZLShipOrderRepository.addTrainZLShipOrder(trainShipOrderReqBO);
    }

    @Override
    public TrainZLShipOrderListRspBO addListTrainZLShipOrder(List<TrainZLShipOrderReqBO> trainShipOrderReqBO) {
        return trainZLShipOrderRepository.addListTrainZLShipOrder(trainShipOrderReqBO);
    }

    @Override
    public TrainZLShipOrderRspBO updateTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO) {
        return trainZLShipOrderRepository.updateTrainZLShipOrder(trainShipOrderReqBO);
    }

    @Override
    public TrainZLShipOrderRspBO saveTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO) {
        return trainZLShipOrderRepository.saveTrainZLShipOrder(trainShipOrderReqBO);
    }

    @Override
    public TrainZLShipOrderRspBO deleteTrainZLShipOrder(TrainZLShipOrderReqBO trainShipOrderReqBO) {
        return trainZLShipOrderRepository.deleteTrainZLShipOrder(trainShipOrderReqBO);
    }
}

