/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.transaction.plugin.advice;

import com.tydic.transaction.plugin.properties.TransactionPluginProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.StringUtils;

@Order(value=-1)
@Configuration
@ConditionalOnProperty(prefix="transaction.plugin", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={TransactionPluginProperties.class})
public class TransactionPluginByPointCutAdvice {
    private static final Logger log = LoggerFactory.getLogger(TransactionPluginByPointCutAdvice.class);
    private static final String POINT_CUT_DELIMITER = ",";
    private static String AOP_POINTCUT_EXPRESSION;
    private TransactionPluginProperties pluginProperties;
    private final PlatformTransactionManager transactionManager;

    public TransactionPluginByPointCutAdvice(TransactionPluginProperties pluginProperties, PlatformTransactionManager transactionManager) {
        this.pluginProperties = pluginProperties;
        this.transactionManager = transactionManager;
    }

    @Bean
    public TransactionInterceptor txAdvice() {
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        RuleBasedTransactionAttribute requireRule = new RuleBasedTransactionAttribute();
        requireRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        requireRule.setPropagationBehavior(0);
        requireRule.setIsolationLevel(2);
        RuleBasedTransactionAttribute readOnlyRule = new RuleBasedTransactionAttribute();
        readOnlyRule.setRollbackRules(Collections.singletonList(new RollbackRuleAttribute(Throwable.class)));
        readOnlyRule.setPropagationBehavior(4);
        readOnlyRule.setIsolationLevel(2);
        readOnlyRule.setReadOnly(true);
        Map<String, TransactionAttribute> txMap = this.buildTxMap(requireRule, readOnlyRule);
        source.setNameMap(txMap);
        return new TransactionInterceptor(this.transactionManager, (TransactionAttributeSource)source);
    }

    private Map<String, TransactionAttribute> buildTxMap(RuleBasedTransactionAttribute requireRule, RuleBasedTransactionAttribute readOnlyRule) {
        List<String> extRequireMethodNames;
        HashMap<String, TransactionAttribute> txMap = new HashMap<String, TransactionAttribute>(16);
        txMap.put("create*", (TransactionAttribute)requireRule);
        txMap.put("register*", (TransactionAttribute)requireRule);
        txMap.put("update*", (TransactionAttribute)requireRule);
        txMap.put("delete*", (TransactionAttribute)requireRule);
        txMap.put("insert*", (TransactionAttribute)requireRule);
        txMap.put("add*", (TransactionAttribute)requireRule);
        txMap.put("modify*", (TransactionAttribute)requireRule);
        txMap.put("save*", (TransactionAttribute)requireRule);
        txMap.put("cancel*", (TransactionAttribute)requireRule);
        txMap.put("change*", (TransactionAttribute)requireRule);
        txMap.put("notify*", (TransactionAttribute)requireRule);
        txMap.put("break*", (TransactionAttribute)requireRule);
        txMap.put("marking*", (TransactionAttribute)requireRule);
        txMap.put("execute*", (TransactionAttribute)requireRule);
        txMap.put("set*", (TransactionAttribute)requireRule);
        txMap.put("record*", (TransactionAttribute)requireRule);
        txMap.put("log*", (TransactionAttribute)requireRule);
        txMap.put("deal*", (TransactionAttribute)requireRule);
        txMap.put("complete*", (TransactionAttribute)requireRule);
        txMap.put("batchDelete*", (TransactionAttribute)requireRule);
        txMap.put("batchInsert*", (TransactionAttribute)requireRule);
        txMap.put("on*", (TransactionAttribute)requireRule);
        txMap.put("query*", (TransactionAttribute)readOnlyRule);
        txMap.put("*", (TransactionAttribute)readOnlyRule);
        if (!StringUtils.isEmpty((Object)this.pluginProperties.getExtRequireMethod())) {
            extRequireMethodNames = Arrays.asList(this.pluginProperties.getExtRequireMethod().split(POINT_CUT_DELIMITER));
            extRequireMethodNames.forEach(item -> {
                TransactionAttribute cfr_ignored_0 = (TransactionAttribute)txMap.put(item + "*", (TransactionAttribute)requireRule);
            });
            log.info("transaction.plugin.extRequireMethod\uff1a{}", (Object)this.pluginProperties.getExtRequireMethod());
        }
        if (!StringUtils.isEmpty((Object)this.pluginProperties.getExtReadOnlyMethod())) {
            extRequireMethodNames = Arrays.asList(this.pluginProperties.getExtReadOnlyMethod().split(POINT_CUT_DELIMITER));
            extRequireMethodNames.forEach(item -> {
                TransactionAttribute cfr_ignored_0 = (TransactionAttribute)txMap.put(item + "*", (TransactionAttribute)readOnlyRule);
            });
            log.info("transaction.plugin.extRequireMethod\uff1a{}", (Object)this.pluginProperties.getExtReadOnlyMethod());
        }
        return txMap;
    }

    @Bean
    public Advisor txAdviceAdvisor() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        this.buildPointCutExpression();
        pointcut.setExpression(AOP_POINTCUT_EXPRESSION);
        DefaultPointcutAdvisor defaultPointcutAdvisor = new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)this.txAdvice());
        log.info("\u4e8b\u52a1\u63d2\u4ef6\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", (Object)AOP_POINTCUT_EXPRESSION);
        return defaultPointcutAdvisor;
    }

    private void buildPointCutExpression() {
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.pluginProperties.getPointCutPackage())) {
            if (this.pluginProperties.getPointCutPackage().contains(POINT_CUT_DELIMITER)) {
                String[] pointCutPackageSplit;
                for (String packageString : pointCutPackageSplit = this.pluginProperties.getPointCutPackage().split(POINT_CUT_DELIMITER)) {
                    if (!StringUtils.hasText((String)packageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("execution(* ").append(packageString).append("..*(..))");
                        continue;
                    }
                    expressionBuilder.append(" || execution(* ").append(packageString).append("..*(..))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("execution(* ").append(this.pluginProperties.getPointCutPackage()).append("..*(..))");
            }
            AOP_POINTCUT_EXPRESSION = expressionBuilder.toString();
        }
    }
}

