/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl;

import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.uac.atom.UacAuditOrderCancelAtomService;
import com.tydic.uac.atom.bo.UacAuditOrderCancelAtomReqBO;
import com.tydic.uac.atom.bo.UacAuditOrderCancelAtomRspBO;
import com.tydic.uac.atom.bo.task.UacCancelOrderReqBO;
import com.tydic.uac.atom.bo.task.UacCancelOrderRspBO;
import com.tydic.uac.atom.task.UacCancelOrderAtomService;
import com.tydic.uac.bo.common.TaskBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalOrderPO;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacAuditOrderCancelAtomService")
public class UacAuditOrderCancelAtomServiceImpl
implements UacAuditOrderCancelAtomService {
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private UacCancelOrderAtomService uacCancelOrderAtomService;
    @Autowired
    private ProcessService processService;

    @Override
    @Transactional
    public UacAuditOrderCancelAtomRspBO dealAuditOrderCancel(UacAuditOrderCancelAtomReqBO reqBO) {
        this.validateParam(reqBO);
        UacAuditOrderCancelAtomRspBO rspBO = new UacAuditOrderCancelAtomRspBO();
        Boolean dateJudge = false;
        ApprovalOrderPO modelBy = new ApprovalOrderPO();
        if (null != reqBO.getOrderId()) {
            ApprovalOrderPO approvalOrderPO = new ApprovalOrderPO();
            approvalOrderPO.setOrderId(reqBO.getOrderId());
            modelBy = this.approvalOrderMapper.getModelBy(approvalOrderPO);
            if (null != modelBy) {
                dateJudge = true;
            }
        }
        if (null != reqBO.getAuditFlag()) {
            if ((UacCommConstant.AUDIT_FLAG.NEED_APPROVAL.equals(reqBO.getAuditFlag()) || dateJudge.equals(false)) && CollectionUtils.isNotEmpty(reqBO.getTaskList())) {
                ArrayList<String> taskIds = new ArrayList<String>();
                for (TaskBO taskBO : reqBO.getTaskList()) {
                    taskIds.add(taskBO.getTaskId());
                }
                this.processService.deleteProcessInstanceBatch(taskIds);
            }
        } else if (dateJudge.booleanValue()) {
            int i = this.approvalOrderMapper.deleteBy(modelBy);
            if (1 != i) {
                throw new BusinessException("5001", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5220\u9664\u5ba1\u6279\u5355\u8868(UOC_APPROVAL_ORDER)\u6570\u91cf\u4e0d\u5bf9\uff0c\u6570\u91cf = " + i);
            }
            ApprovalOrderPO approvalOrderPO = this.approvalOrderMapperParam(modelBy);
            try {
                int insert = this.approvalOrderMapper.insert(approvalOrderPO);
                if (1 != insert) {
                    throw new BusinessException("5001", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u63d2\u5165\u5ba1\u6279\u5355\u8868(UOC_APPROVAL_ORDER)\u6570\u91cf\u4e0d\u5bf9\uff0c\u6570\u91cf = " + insert);
                }
            }
            catch (Exception e) {
                throw new BusinessException("5001", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u63d2\u5165\u5ba1\u6279\u5355\u8868(UOC_APPROVAL_ORDER)\u5f02\u5e38\uff01" + e.getMessage());
            }
            UacCancelOrderReqBO uacCancelOrderReqBO = this.uacCancelOrderAtomParam(reqBO);
            UacCancelOrderRspBO uacCancelOrderRspBO = this.uacCancelOrderAtomService.dealCoreCancelOrder(uacCancelOrderReqBO);
            if (!"0000".equals(uacCancelOrderRspBO.getRespCode())) {
                throw new BusinessException("5001", "\u8c03\u7528\u8ba2\u5355\u57fa\u7840\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + uacCancelOrderRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rspBO;
    }

    private void validateParam(UacAuditOrderCancelAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getAuditFlag() || UacCommConstant.AUDIT_FLAG.NEED_APPROVAL.equals(reqBO.getAuditFlag())) {
            if (null == reqBO.getOrderId()) {
                throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5ba1\u6279\u5355ID\uff08orderId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else if (null == reqBO.getCancelOperId()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u64a4\u9500\u539f\u5b50\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u8005\uff08cancelOperId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private ApprovalOrderPO approvalOrderMapperParam(ApprovalOrderPO approvalOrderPO) {
        approvalOrderPO.setStatus(UacCommConstant.STATUS.APPROVAL_WITHDRAWAL);
        approvalOrderPO.setFinishTime(new Date());
        return approvalOrderPO;
    }

    private UacCancelOrderReqBO uacCancelOrderAtomParam(UacAuditOrderCancelAtomReqBO reqBO) {
        UacCancelOrderReqBO uacCancelOrderReqBO = new UacCancelOrderReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uacCancelOrderReqBO);
        uacCancelOrderReqBO.setOrderId(reqBO.getOrderId());
        uacCancelOrderReqBO.setCancelOperId(reqBO.getCancelOperId());
        return uacCancelOrderReqBO;
    }
}

