/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.uac.atom.UacAuditOrderCreateAtomService;
import com.tydic.uac.atom.bo.UacAuditOrderCreateAtomReqBO;
import com.tydic.uac.atom.bo.UacAuditOrderCreateAtomRspBO;
import com.tydic.uac.atom.bo.task.UacStartProcessReqBO;
import com.tydic.uac.atom.bo.task.UacStartProcessRspBO;
import com.tydic.uac.atom.task.UacStartProcessAtomService;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.bo.common.TaskBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uac.util.UacCommTools;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacAuditOrderCreateAtomService")
public class UacAuditOrderCreateAtomServiceImpl
implements UacAuditOrderCreateAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UacAuditOrderCreateAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private UacStartProcessAtomService uacStartProcessAtomService;
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;

    @Override
    @Transactional
    public UacAuditOrderCreateAtomRspBO dealAuditOrderCreate(UacAuditOrderCreateAtomReqBO reqBO) {
        this.validateParam(reqBO);
        Sequence sequence = Sequence.getInstance();
        Long orderId = reqBO.getOrderId() != null ? reqBO.getOrderId() : Long.valueOf(sequence.nextId());
        UacAuditOrderCreateAtomRspBO rspBO = new UacAuditOrderCreateAtomRspBO();
        UacStartProcessReqBO processReqBO = this.uacStartProcessAtomParam(reqBO, orderId);
        UacStartProcessRspBO uacStartProcessRspBO = this.uacStartProcessAtomService.dealCoreStartProcess(processReqBO);
        LOGGER.debug("\u542f\u52a8\u6d41\u7a0b\u56de\u53c2\uff1a" + JSON.toJSONString((Object)((Object)uacStartProcessRspBO)));
        if (!"0000".equals(uacStartProcessRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u542f\u52a8\u6d41\u7a0b\u5931\u8d25:" + uacStartProcessRspBO.getRespDesc());
        }
        if ("0000".equals(uacStartProcessRspBO.getRespCode())) {
            ApprovalOrderPO approvalOrderPO = this.approvalOrderMapperParam(reqBO, orderId);
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u63d2\u5165\u5ba1\u6279\u5355\u8868PO:" + approvalOrderPO.toString());
            }
            Long auditOrderId = sequence.nextId();
            try {
                approvalOrderPO.setAuditOrderId(auditOrderId);
                int insert = this.approvalOrderMapper.insert(approvalOrderPO);
                rspBO.setApprovalOrderPO(approvalOrderPO);
                if (1 != insert) {
                    throw new BusinessException("5001", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u63d2\u5165\u5ba1\u6279\u5355\u8868(UOC_APPROVAL_ORDER)\u6570\u91cf\u4e0d\u5bf9\uff0c\u6570\u91cf = " + insert);
                }
            }
            catch (Exception e) {
                throw new BusinessException("5001", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u63d2\u5165\u5ba1\u6279\u5355\u8868(UOC_APPROVAL_ORDER)\u5f02\u5e38\uff01" + e.getMessage());
            }
            List<ApprovalObjPO> approvalObjPOList = this.approvalObjMapperParam(reqBO, orderId, auditOrderId, sequence);
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u6279\u91cf\u63d2\u5165\u5ba1\u6279\u5bf9\u8c61\u8868PO:" + approvalObjPOList.toString());
            }
            try {
                this.approvalObjMapper.insertBatch(approvalObjPOList);
            }
            catch (Exception e) {
                throw new BusinessException("5001", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u6279\u91cf\u63d2\u5165\u5ba1\u6279\u5bf9\u8c61\u8868(UOC_APPROVAL_OBJ)\u5f02\u5e38\uff01" + e.getMessage());
            }
            rspBO.setOrderId(orderId);
            rspBO.setAuditFlag(UacCommConstant.AUDIT_FLAG.NEED_APPROVAL);
            rspBO.setExtField1(reqBO.getExtField1());
            if (null != reqBO.getExtField2()) {
                rspBO.setExtField2(reqBO.getExtField2());
            }
            ArrayList<TaskBO> taskList = new ArrayList<TaskBO>();
            for (com.tydic.uac.bo.task.TaskBO taskBOL : uacStartProcessRspBO.getTaskList()) {
                TaskBO taskBO = new TaskBO();
                BeanUtils.copyProperties((Object)taskBOL, (Object)taskBO);
                taskList.add(taskBO);
            }
            rspBO.setTaskList(taskList);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u627e\u5230\u5bf9\u5e94\u6d41\u7a0b\u540e\u6210\u529f\uff01");
        }
        return rspBO;
    }

    private void validateParam(UacAuditOrderCreateAtomReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff08reqBO\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getObjType()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u7c7b\u578b\uff08objType\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getObjNum()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5bf9\u8c61\u6570\u91cf\uff08objNum\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getApprovalObjInfo()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5ba1\u6279\u5bf9\u8c61\u4fe1\u606f\uff08approvalObjInfo\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getBusiCode()) {
            throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e1a\u52a1\u7f16\u7801\uff08busiCode\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != reqBO.getApprovalObjInfo()) {
            for (ApprovalObjBO approvalObjBO : reqBO.getApprovalObjInfo()) {
                if (null != approvalObjBO.getObjId()) continue;
                throw new BusinessException("8000", "\u8ba2\u5355\u5ba1\u6279\u8ba2\u5355\u521b\u5efa\u539f\u5b50\u670d\u52a1\u5165\u53c2\u5ba1\u6279\u5bf9\u8c61\u4fe1\u606f\u4e2d\u5bf9\u8c61ID\uff08objId\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private UacStartProcessReqBO uacStartProcessAtomParam(UacAuditOrderCreateAtomReqBO reqBO, Long orderId) {
        UacStartProcessReqBO uacStartProcessReqBO = new UacStartProcessReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uacStartProcessReqBO);
        uacStartProcessReqBO.setOrderId(orderId);
        if (StringUtils.isBlank((String)reqBO.getObjType())) {
            uacStartProcessReqBO.setObjType(UacCommConstant.OBJ_TYPE.ORDER);
            try {
                uacStartProcessReqBO.setObjId(Long.valueOf(reqBO.getApprovalObjInfo().get(0).getObjId()));
            }
            catch (Exception e) {
                uacStartProcessReqBO.setObjId(orderId);
            }
        } else {
            try {
                uacStartProcessReqBO.setObjId(Long.valueOf(reqBO.getApprovalObjInfo().get(0).getObjId()));
            }
            catch (Exception e) {
                uacStartProcessReqBO.setObjId(orderId);
            }
            uacStartProcessReqBO.setObjType(Integer.parseInt(reqBO.getObjType()));
        }
        uacStartProcessReqBO.setBusiCode(reqBO.getBusiCode());
        if (null != reqBO.getParamMap()) {
            uacStartProcessReqBO.setParamMap(reqBO.getParamMap());
        }
        return uacStartProcessReqBO;
    }

    private ApprovalOrderPO approvalOrderMapperParam(UacAuditOrderCreateAtomReqBO reqBO, Long orderId) {
        ApprovalOrderPO approvalOrderPO = new ApprovalOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approvalOrderPO);
        approvalOrderPO.setOrderId(orderId);
        approvalOrderPO.setObjType(UacCommTools.string2Integer(reqBO.getObjType()));
        approvalOrderPO.setObjNum(UacCommTools.string2Integer(reqBO.getObjNum()));
        approvalOrderPO.setStatus(UacCommConstant.STATUS.UNDER_REVIEW);
        approvalOrderPO.setAuditConsumerType(reqBO.getAuditConsumerType());
        approvalOrderPO.setCreateTime(new Date());
        approvalOrderPO.setCreateOperId(reqBO.getCreateOperId());
        return approvalOrderPO;
    }

    private List<ApprovalObjPO> approvalObjMapperParam(UacAuditOrderCreateAtomReqBO reqBO, Long orderId, Long auditOrderId, Sequence sequence) {
        ArrayList<ApprovalObjPO> approvalObjPOList = new ArrayList<ApprovalObjPO>();
        for (ApprovalObjBO approvalObjBO : reqBO.getApprovalObjInfo()) {
            ApprovalObjPO approvalObjPO = new ApprovalObjPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
            BeanUtils.copyProperties((Object)approvalObjBO, (Object)approvalObjPO);
            approvalObjPO.setAuditOrderId(auditOrderId);
            approvalObjPO.setOrderId(orderId);
            approvalObjPO.setId(sequence.nextId());
            approvalObjPO.setObjType(UacCommTools.string2Integer(reqBO.getObjType()));
            approvalObjPOList.add(approvalObjPO);
        }
        return approvalObjPOList;
    }
}

