/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.uac.atom.bo.task.UacCreateTaskReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskRspBO;
import com.tydic.uac.atom.task.UacCreateTaskAtomService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrdTaskCandidateMapper;
import com.tydic.uac.dao.task.UacOrdTaskMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrdTaskCandidatePO;
import com.tydic.uac.po.task.OrdTaskPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uacCreateTaskAtomService")
public class UacCreateTaskAtomServiceImpl
implements UacCreateTaskAtomService {
    @Autowired
    private UacOrdTaskMapper uacOrdTaskMapper;
    @Autowired
    private UacOrdTaskCandidateMapper uacOrdTaskCandidateMapper;

    @Override
    public UacCreateTaskRspBO createTask(UacCreateTaskReqBO reqBO) {
        List candidates;
        UacCreateTaskRspBO rspBO = new UacCreateTaskRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Sequence sequence = Sequence.getInstance();
        OrdTaskPO taskPO = new OrdTaskPO();
        taskPO.setOrderId(reqBO.getOrderId());
        taskPO.setObjId(reqBO.getAuditOrderId());
        taskPO.setObjType(UacCommConstant.ORDER_TYPE.AUDIT_NO_TASK);
        taskPO.setTaskState(UacCommConstant.TASK_STATE.UNPROCESS);
        StepWithOutInstance instance = reqBO.getInstance();
        taskPO.setTacheCode(instance.getStepId());
        taskPO.setProcInstId(instance.getProcDefId());
        taskPO.setBusiCode(instance.getProcDefKey());
        taskPO.setTaskName(instance.getStepName());
        taskPO.setProcTaskState(UacCommConstant.TASK_CREATE);
        taskPO.setCreateTime(new Date());
        taskPO.setTaskId(String.valueOf(sequence.nextId()));
        try {
            this.uacOrdTaskMapper.insert(taskPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u521b\u5efa\u4efb\u52a1\u5931\u8d25" + e.getMessage());
        }
        if (reqBO.getCandidates() != null && !reqBO.getCandidates().isEmpty()) {
            this.save(reqBO.getCandidates(), reqBO, sequence, taskPO, null);
            return rspBO;
        }
        if (instance.getCustomAttributes() != null && !instance.getCustomAttributes().isEmpty()) {
            Map map = instance.getCustomAttributes();
            this.save(map, reqBO, sequence, taskPO, UacCommConstant.CandidateType.STATION);
        }
        if (instance.getTaskList() != null && !instance.getTaskList().isEmpty() && (candidates = ((Task)instance.getTaskList().get(0)).getCandidates()) != null && candidates.size() > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String str : candidates) {
                JSONObject jsonObject = JSONObject.parseObject((String)str);
                map.put(jsonObject.getString("userId"), jsonObject.getString("userName"));
            }
            this.save(map, reqBO, sequence, taskPO, UacCommConstant.CandidateType.USER);
        }
        return rspBO;
    }

    private void save(Map<String, Object> map, UacCreateTaskReqBO reqBO, Sequence sequence, OrdTaskPO taskPO, Integer type) {
        ArrayList<OrdTaskCandidatePO> taskCandidatePOS = new ArrayList<OrdTaskCandidatePO>(map.size());
        for (String key : map.keySet()) {
            OrdTaskCandidatePO candidatePO = new OrdTaskCandidatePO();
            candidatePO.setOperName((String)map.get(key));
            candidatePO.setOperId(key);
            candidatePO.setType(type);
            candidatePO.setOrderId(reqBO.getOrderId());
            candidatePO.setId(sequence.nextId());
            candidatePO.setTaskId(taskPO.getTaskId());
            taskCandidatePOS.add(candidatePO);
        }
        try {
            this.uacOrdTaskCandidateMapper.insertBatch(taskCandidatePOS);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u521b\u5efa\u4efb\u52a1\u5019\u9009\u4eba\u5931\u8d25" + e.getMessage());
        }
    }
}

