/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.atom.impl.task;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.engine.runtime.NextStepsResult;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.uac.atom.bo.task.UacCreateTaskInstReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskInstRspBO;
import com.tydic.uac.atom.bo.task.UacStartProcessReqBO;
import com.tydic.uac.atom.bo.task.UacStartProcessRspBO;
import com.tydic.uac.atom.task.UacCreateTaskInstAtomService;
import com.tydic.uac.atom.task.UacStartProcessAtomService;
import com.tydic.uac.bo.task.TaskBO;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.task.UacOrdVoucherProcessMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.task.OrdVoucherProcessPO;
import com.tydic.uac.util.ParamUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="uacStartProcessAtomService")
public class UacStartProcessAtomServiceImpl
implements UacStartProcessAtomService {
    private static final Logger logger = LoggerFactory.getLogger(UacStartProcessAtomServiceImpl.class);
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String prcSysCode;
    private ProcessService processService;
    private UacCreateTaskInstAtomService uacCreateTaskInstAtomService;
    private UacOrdVoucherProcessMapper ordVoucherProcessMapper;

    @Autowired
    public UacStartProcessAtomServiceImpl(ProcessService processService, UacCreateTaskInstAtomService uacCreateTaskInstAtomService, UacOrdVoucherProcessMapper ordVoucherProcessMapper) {
        this.processService = processService;
        this.uacCreateTaskInstAtomService = uacCreateTaskInstAtomService;
        this.ordVoucherProcessMapper = ordVoucherProcessMapper;
    }

    @Override
    public UacStartProcessRspBO dealCoreStartProcess(UacStartProcessReqBO reqBO) {
        Long orderId = reqBO.getOrderId();
        Integer objType = reqBO.getObjType();
        String busiCode = reqBO.getBusiCode();
        if (orderId == null || objType == null || StringUtils.isBlank((String)busiCode)) {
            throw new BusinessException("8000", "\u8ba2\u5355Id\uff0c\u5355\u636e\u7c7b\u578b\uff0c\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UacCommConstant.OBJ_TYPE.ORDER.equals(objType) && reqBO.getObjId() == null) {
            throw new BusinessException("8000", "\u5355\u636eId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UacStartProcessRspBO rspBO = new UacStartProcessRspBO();
        NextStepsResult nextStepsResult = this.processService.newProcessStartBuilder().sysCode(this.prcSysCode).procDefKey(busiCode).variables(reqBO.getParamMap()).partitionKey(String.valueOf(reqBO.getOrderId())).startWithInstance();
        OrdVoucherProcessPO ordVoucherProcPO = new OrdVoucherProcessPO();
        Sequence sequence = Sequence.getInstance();
        ordVoucherProcPO.setId(sequence.nextId());
        ordVoucherProcPO.setOrderId(orderId);
        if (CollectionUtils.isNotEmpty((Collection)nextStepsResult.getTaskList())) {
            ordVoucherProcPO.setProcInstId(((Task)nextStepsResult.getTaskList().get(0)).getProcInstId());
        }
        ordVoucherProcPO.setObjId(reqBO.getObjId() == null ? null : String.valueOf(reqBO.getObjId()));
        ordVoucherProcPO.setObjType(objType);
        ordVoucherProcPO.setProcState("ACTIVE");
        try {
            this.ordVoucherProcessMapper.insert(ordVoucherProcPO);
            UacCreateTaskInstReqBO createTaskInstAtomReqBO = new UacCreateTaskInstReqBO();
            createTaskInstAtomReqBO.setOrderId(orderId);
            createTaskInstAtomReqBO.setObjType(objType);
            createTaskInstAtomReqBO.setObjId(reqBO.getObjId());
            createTaskInstAtomReqBO.setOperId(reqBO.getOperId());
            if (CollectionUtils.isNotEmpty((Collection)nextStepsResult.getTaskList())) {
                List<TaskBO> taskList = ParamUtils.getTask(nextStepsResult.getTaskList());
                createTaskInstAtomReqBO.setTaskList(taskList);
                rspBO.setTaskList(taskList);
            }
            createTaskInstAtomReqBO.setDealDesc("\u542f\u52a8\u6d41\u7a0b\u521b\u5efa\u4efb\u52a1");
            UacCreateTaskInstRspBO createTaskInstAtomRspBO = this.uacCreateTaskInstAtomService.dealCoreCreateTaskInst(createTaskInstAtomReqBO);
            if (!"0000".equals(createTaskInstAtomRspBO.getRespCode())) {
                rspBO.setRespCode(createTaskInstAtomRspBO.getRespCode());
                rspBO.setRespDesc(createTaskInstAtomRspBO.getRespDesc());
                return rspBO;
            }
        }
        catch (Exception e) {
            logger.error("\u6d41\u7a0b\u542f\u52a8\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8\u670d\u52a1\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6d41\u7a0b\u542f\u52a8\u6210\u529f");
        return rspBO;
    }
}

