/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uac.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.osworkflow.engine.runtime.ProcessService;
import com.tydic.osworkflow.engine.runtime.StepWithOutInstance;
import com.tydic.osworkflow.engine.runtime.Task;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskReqBO;
import com.tydic.uac.atom.bo.task.UacCreateTaskRspBO;
import com.tydic.uac.atom.task.UacCreateTaskAtomService;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uac.busi.UacNoTaskAuditCreateBusiService;
import com.tydic.uac.constant.UacCommConstant;
import com.tydic.uac.dao.ApprovalLogMapper;
import com.tydic.uac.dao.ApprovalObjMapper;
import com.tydic.uac.dao.ApprovalOrderMapper;
import com.tydic.uac.dao.ApprovalStepTempDateMapper;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uac.po.ApprovalLogPO;
import com.tydic.uac.po.ApprovalObjPO;
import com.tydic.uac.po.ApprovalOrderPO;
import com.tydic.uac.po.ApprovalStepTempDataPO;
import com.tydic.uac.util.UacCommTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="uacNoTaskAuditCreateBusiService")
public class UacNoTaskAuditCreateBusiServiceImpl
implements UacNoTaskAuditCreateBusiService {
    @Autowired
    private ApprovalOrderMapper approvalOrderMapper;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ApprovalObjMapper approvalObjMapper;
    @Autowired
    private ApprovalStepTempDateMapper approvalStepTempDateMapper;
    @Value(value="${CALL_PRC_SYS_CODE}")
    private String sysCode;
    private static final Logger LOGGER = LoggerFactory.getLogger(UacNoTaskAuditCreateBusiServiceImpl.class);
    @Autowired
    private UacCreateTaskAtomService uacCreateTaskAtomService;
    @Autowired
    private ApprovalLogMapper approvalLogMapper;

    @Transactional
    public UacNoTaskAuditCreateRspBO auditOrderCreate(UacNoTaskAuditCreateReqBO reqBO) {
        this.val(reqBO);
        StepWithOutInstance stepInstance = this.processService.newProcessStartBuilder().procDefId(reqBO.getProcDefId()).procDefKey(reqBO.getProcDefKey()).sysCode(this.sysCode).variables(reqBO.getVariables()).startWithOutInstance();
        Sequence sequence = Sequence.getInstance();
        ArrayList<Long> orderIds = new ArrayList<Long>();
        ArrayList<Long> auditOrderIds = new ArrayList<Long>();
        for (UacNoTaskAuditCreateInfoReqBO bo : reqBO.getCreateBusiReqBO()) {
            Long orderId = bo.getOrderId() != null ? bo.getOrderId() : Long.valueOf(sequence.nextId());
            ApprovalOrderPO approvalOrderPO = this.saveApprovalOrder(bo, orderId, reqBO.getAuditConsumerType(), sequence.nextId(), stepInstance.getStepId());
            this.saveApprovalObj(bo, orderId, approvalOrderPO.getAuditOrderId(), sequence);
            this.saveTempData(orderId, approvalOrderPO.getAuditOrderId(), stepInstance);
            orderIds.add(orderId);
            auditOrderIds.add(approvalOrderPO.getAuditOrderId());
            this.createTask(orderId, approvalOrderPO.getAuditOrderId(), stepInstance, reqBO);
            if (reqBO.getIsSaveCreateLog() == null || !reqBO.getIsSaveCreateLog().booleanValue()) continue;
            this.saveLog(approvalOrderPO, reqBO, stepInstance, bo);
        }
        UacNoTaskAuditCreateRspBO rspBO = new UacNoTaskAuditCreateRspBO();
        BeanUtils.copyProperties((Object)stepInstance, (Object)rspBO);
        rspBO.setAuditOrderId(auditOrderIds);
        rspBO.setCustomAttributes(stepInstance.getCustomAttributes());
        rspBO.setOrderId(orderIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveLog(ApprovalOrderPO approvalOrderPO, UacNoTaskAuditCreateReqBO reqBO, StepWithOutInstance stepInstance, UacNoTaskAuditCreateInfoReqBO infoReqBO) {
        List candidates;
        Sequence sequence = Sequence.getInstance();
        ApprovalLogPO logPO = new ApprovalLogPO();
        BeanUtils.copyProperties((Object)approvalOrderPO, (Object)logPO);
        logPO.setId(sequence.nextId());
        logPO.setOrderId(approvalOrderPO.getOrderId());
        logPO.setOperid(reqBO.getCreateOperId());
        logPO.setOperName(reqBO.getCreateOperName());
        if (StringUtils.isNotBlank((CharSequence)infoReqBO.getRemark())) {
            logPO.setAuditAdvice(infoReqBO.getRemark());
        } else {
            logPO.setAuditAdvice("\u53d1\u8d77\u5ba1\u6279");
        }
        logPO.setAuditOrderId(approvalOrderPO.getAuditOrderId());
        logPO.setNextStepId(stepInstance.getStepId());
        logPO.setNextStepName(stepInstance.getStepName());
        logPO.setNextStepDesc(stepInstance.getStepDesc());
        logPO.setFinish(stepInstance.getIsFinish() != false ? 1 : 0);
        logPO.setOperDept(reqBO.getCreateOperDept());
        logPO.setDealTime(new Date());
        if (stepInstance.getCustomAttributes() != null && !stepInstance.getCustomAttributes().isEmpty()) {
            int i = 0;
            StringBuilder id = new StringBuilder();
            StringBuilder name = new StringBuilder();
            for (String key : stepInstance.getCustomAttributes().keySet()) {
                name.append(",").append(stepInstance.getCustomAttributes().get(key));
                id.append(",").append(key);
                if (++i != 50) continue;
                break;
            }
            logPO.setNextStationId(id.substring(id.indexOf(",") + 1));
            logPO.setNextStationName(name.substring(name.indexOf(",") + 1));
        }
        if (stepInstance.getTaskList() != null && !stepInstance.getTaskList().isEmpty() && (candidates = ((Task)stepInstance.getTaskList().get(0)).getCandidates()) != null && candidates.size() > 0) {
            int i = 0;
            StringBuilder id = new StringBuilder();
            StringBuilder name = new StringBuilder();
            for (String str : candidates) {
                JSONObject jsonObject = JSONObject.parseObject((String)str);
                jsonObject.getString("userId");
                jsonObject.getString("userName");
                name.append(",").append(jsonObject.getString("userName"));
                id.append(",").append(jsonObject.getString("userId"));
                if (++i == 50) break;
                logPO.setNextOperId(id.substring(id.indexOf(",") + 1));
                logPO.setNextOperName(name.substring(name.indexOf(",") + 1));
            }
        }
        try {
            this.approvalLogMapper.insert(logPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fdd\u5b58\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private void createTask(Long orderId, Long auditOrderId, StepWithOutInstance instance, UacNoTaskAuditCreateReqBO reqBO) {
        UacCreateTaskReqBO uacCreateTaskReqBO = new UacCreateTaskReqBO();
        uacCreateTaskReqBO.setAuditOrderId(auditOrderId);
        uacCreateTaskReqBO.setOrderId(orderId);
        uacCreateTaskReqBO.setInstance(instance);
        uacCreateTaskReqBO.setCandidates(reqBO.getCandidates());
        UacCreateTaskRspBO uacCreateTaskRspBO = this.uacCreateTaskAtomService.createTask(uacCreateTaskReqBO);
        if (!"0000".equals(uacCreateTaskRspBO.getRespCode())) {
            throw new BusinessException("6001", "\u521b\u5efa\u73af\u8282\u5b9e\u4f8b\u5931\u8d25");
        }
    }

    private void saveTempData(Long orderId, Long auditOrderId, StepWithOutInstance instance) {
        ApprovalStepTempDataPO dataPO = new ApprovalStepTempDataPO();
        dataPO.setAuditOrderId(auditOrderId);
        dataPO.setOrderId(orderId);
        dataPO.setStepDesc(instance.getStepDesc());
        dataPO.setStepId(instance.getStepId());
        dataPO.setStepName(instance.getStepName());
        dataPO.setCreateTime(new Date());
        try {
            this.approvalStepTempDateMapper.insert(dataPO);
        }
        catch (Exception e) {
            LOGGER.debug("\u4fdd\u5b58\u6b65\u9aa4\u5931\u8d25" + e);
            throw new BusinessException("6001", "\u4fdd\u5b58\u6b65\u9aa4\u5931\u8d25" + e);
        }
    }

    private void saveApprovalObj(UacNoTaskAuditCreateInfoReqBO reqBO, Long orderId, Long auditOrderId, Sequence sequence) {
        ArrayList<ApprovalObjPO> list = new ArrayList<ApprovalObjPO>();
        for (ApprovalObjBO approvalObjBO : reqBO.getApprovalObjInfo()) {
            ApprovalObjPO approvalObjPO = new ApprovalObjPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)approvalObjPO);
            BeanUtils.copyProperties((Object)approvalObjBO, (Object)approvalObjPO);
            approvalObjPO.setAuditOrderId(auditOrderId);
            approvalObjPO.setOrderId(orderId);
            approvalObjPO.setId(sequence.nextId());
            approvalObjPO.setObjType(reqBO.getObjType());
            list.add(approvalObjPO);
        }
        try {
            this.approvalObjMapper.insertBatch(list);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fdd\u5b58\u5ba1\u6279\u5bf9\u8c61\u5931\u8d25");
        }
    }

    private ApprovalOrderPO saveApprovalOrder(UacNoTaskAuditCreateInfoReqBO reqBO, Long orderId, Integer auditConsumerType, Long auditId, String stepId) {
        ApprovalOrderPO approvalOrderPO = new ApprovalOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approvalOrderPO);
        approvalOrderPO.setOrderId(orderId);
        approvalOrderPO.setAuditOrderId(auditId);
        approvalOrderPO.setObjType(reqBO.getObjType());
        approvalOrderPO.setObjNum(UacCommTools.string2Integer(reqBO.getObjNum()));
        approvalOrderPO.setStatus(UacCommConstant.STATUS.UNDER_REVIEW);
        approvalOrderPO.setAuditConsumerType(auditConsumerType);
        approvalOrderPO.setCreateTime(new Date());
        approvalOrderPO.setStepId(stepId);
        try {
            this.approvalOrderMapper.insert(approvalOrderPO);
        }
        catch (Exception e) {
            throw new BusinessException("6001", "\u4fdd\u5b58\u5ba1\u6279\u5355\u8868\u5931\u8d25");
        }
        return approvalOrderPO;
    }

    private void val(UacNoTaskAuditCreateReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2reqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getProcDefId() == null && reqBO.getProcDefKey() == null) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2procDefKey,procDefId\u90fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCreateBusiReqBO())) {
            throw new BusinessException("8000", "\u65e0\u6d41\u7a0b\u5ba1\u6279\u5355\u521b\u5efa\u5165\u53c2createBusiReqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

